/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.resource.RJavaProgram;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class AS400ClassPathOptimizer {
    public static final int NO_OPTIMIZATION = 0;
    public static final int LEVEL_10 = 10;
    public static final int LEVEL_20 = 20;
    public static final int LEVEL_30 = 30;
    public static final int LEVEL_40 = 40;
    public static final String LICOPT_NOPRERESOLVEEXTREF = "NOPRERESOLVEEXTREF";
    private AS400 as400_;
    private CommandCall commandCall_;
    private String classpath_;
    private boolean wait_ = false;
    private boolean optimizeInParallel_ = false;
    private int optimizationLevel_ = 0;
    private boolean optimizeDirectories_ = false;
    private String licensedInternalCodeOptions_ = "NOPRERESOLVEEXTREF";
    private PrintStream out_;

    public AS400ClassPathOptimizer() {
        this(null, null);
    }

    public AS400ClassPathOptimizer(AS400 aS400) {
        this(aS400, null);
    }

    public AS400ClassPathOptimizer(AS400 aS400, String string) {
        this.setAS400(aS400);
        this.setClasspath(string);
    }

    public void setClasspath(String string) {
        this.classpath_ = string;
    }

    public void setAS400(AS400 aS400) {
        this.as400_ = aS400;
    }

    public void setWaitForOptimizations(boolean bl) {
        this.wait_ = bl;
    }

    public boolean isWaitForOptimizations() {
        return this.wait_;
    }

    public void setOptimizeInParallel(boolean bl) {
        this.optimizeInParallel_ = bl;
    }

    public void setOptimizeDirectories(boolean bl) {
        this.optimizeDirectories_ = bl;
    }

    public boolean isOptimizeInParallel() {
        return this.optimizeInParallel_;
    }

    public String getLicensedInternalCodeOptions() {
        return this.licensedInternalCodeOptions_;
    }

    public void setLicensedInternalCodeOptions(String string) {
        this.licensedInternalCodeOptions_ = string;
    }

    public void setOptimizationLevel(int n) {
        this.optimizationLevel_ = n;
    }

    public void setOutputLog(PrintStream printStream) {
        this.out_ = printStream;
    }

    public void optimize() throws Exception {
        if (this.optimizeInParallel_) {
            this.wait_ = false;
        }
        this.run();
    }

    public void run() throws Exception {
        this.logit("classpath=" + this.classpath_);
        this.logit("wait=" + this.wait_);
        this.logit("optimizationLevel=" + this.optimizationLevel_);
        this.logit("optimizeDirectories=" + this.optimizeDirectories_);
        this.logit("optimizeInParallel=" + this.optimizeInParallel_);
        this.logit("licensedInternalCodeOptions=" + this.licensedInternalCodeOptions_);
        StringTokenizer stringTokenizer = new StringTokenizer(this.classpath_, ";:");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            IFSFile iFSFile = new IFSFile(this.as400_, string);
            if (iFSFile.isDirectory() && !this.optimizeDirectories_) {
                this.logit(string + " is a directory and optimize directories is false.");
                continue;
            }
            if (iFSFile.isAbsolute() && !iFSFile.exists()) {
                this.logit(string + " does not exist.");
                continue;
            }
            if (!iFSFile.isAbsolute()) {
                this.logit(string + " must be an absolute path to be optimized.");
                continue;
            }
            int n = this.retrieveOptimizationLevel(iFSFile);
            if (n < this.optimizationLevel_) {
                this.optimize(iFSFile);
                this.logit(string + " currently optimized at level " + n + " optimizing to level " + this.optimizationLevel_);
                continue;
            }
            this.logit(string + " currently optimized at level " + n + " not optimizing.");
        }
    }

    private void optimize(IFSFile iFSFile) throws Exception {
        String string = this.getOptimizationCommand(iFSFile);
        if (this.wait_) {
            this.runCommand(string);
        } else if (this.optimizeInParallel_) {
            this.runCommand("SBMJOB JOB(CRTJVAPGM) CMD(" + string + ")");
        }
    }

    void logit(String string) {
        if (this.out_ != null) {
            this.out_.println(string);
        }
    }

    private String getOptimizationCommand(IFSFile iFSFile) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CRTJVAPGM ");
        stringBuffer.append("CLSF(" + iFSFile.getAbsolutePath() + ") ");
        stringBuffer.append("OPTIMIZE(" + this.optimizationLevel_ + ") ");
        if (iFSFile.isDirectory() && this.optimizeDirectories_) {
            stringBuffer.append("SUBTREE(*ALL) ");
        }
        if (this.licensedInternalCodeOptions_ != null) {
            stringBuffer.append("LICOPT(" + this.licensedInternalCodeOptions_ + ") ");
        }
        return stringBuffer.toString();
    }

    void runCommand(String string) throws Exception {
        if (this.commandCall_ == null) {
            this.commandCall_ = new CommandCall(this.as400_);
        }
        this.logit(string);
        boolean bl = this.commandCall_.run(string);
        if (!bl) {
            AS400Message[] aS400MessageArray = this.commandCall_.getMessageList();
            this.logit("error running command " + string);
            for (int i = 0; i < aS400MessageArray.length; ++i) {
                this.logit(i + ":" + aS400MessageArray[i].getText());
            }
        }
    }

    int retrieveOptimizationLevel(IFSFile iFSFile) throws Exception {
        RJavaProgram rJavaProgram = new RJavaProgram(this.as400_, iFSFile.getAbsolutePath());
        Integer n = (Integer)rJavaProgram.getAttributeUnchangedValue("OPTIMIZATION");
        return n;
    }
}

