/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.CommTrace;
import com.ibm.as400.util.commtrace.ResourceBundleLoader_ct;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class Find
extends WindowAdapter
implements KeyListener {
    private JTextArea ta;
    private JFrame find;
    private JButton fnext;
    private JButton cancel;
    private boolean isClosed = false;
    private JCheckBox casebox;
    private JCheckBox wrapbox;
    private JCheckBox reverse;
    private JTextField input;
    private int index = 0;
    private String search = "";

    public Find(JTextArea jTextArea) {
        this.ta = jTextArea;
        this.createDialog();
    }

    public void toFront() {
        this.find.toFront();
    }

    private void createDialog() {
        if (this.find != null) {
            this.find.toFront();
            return;
        }
        this.find = new JFrame(ResourceBundleLoader_ct.getText("Find"));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.input = new JTextField(30);
        this.fnext = new JButton(ResourceBundleLoader_ct.getText("FindNext"));
        this.fnext.addKeyListener(this);
        this.cancel = new JButton(ResourceBundleLoader_ct.getText("Cancel"));
        this.cancel.addKeyListener(this);
        this.casebox = new JCheckBox(ResourceBundleLoader_ct.getText("MatchCase"), true);
        this.wrapbox = new JCheckBox(ResourceBundleLoader_ct.getText("WrapSearch"), true);
        this.reverse = new JCheckBox(ResourceBundleLoader_ct.getText("Reverse"), false);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagLayout.setConstraints(this.input, gridBagConstraints);
        jPanel.add(this.input);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagLayout.setConstraints(this.fnext, gridBagConstraints);
        jPanel.add(this.fnext);
        this.fnext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Find.this.findnext(Find.this.input.getText());
            }
        });
        jPanel.add(this.wrapbox);
        jPanel.add(this.casebox);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.reverse, gridBagConstraints);
        jPanel.add(this.reverse);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.cancel, gridBagConstraints);
        jPanel.add(this.cancel);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Find.this.close();
            }
        });
        this.find.getContentPane().add(jPanel);
        this.find.addWindowListener(this);
        this.find.setSize(400, 100);
        this.find.setVisible(true);
        this.find.invalidate();
        this.find.validate();
        this.find.repaint();
    }

    public void findnext(String string) {
        int n = 0;
        this.search = string;
        String string2 = this.ta.getText();
        if (!this.casebox.isSelected()) {
            string2 = string2.toLowerCase();
            string = string.toLowerCase();
        }
        if (string != null) {
            if (string.length() == 0) {
                CommTrace.error(this.find, "Error", "No String specified");
            } else {
                n = this.reverse.isSelected() ? string2.lastIndexOf(string, this.index - string.length()) : string2.indexOf(string, this.index + string.length());
                if (n != -1) {
                    this.ta.select(n, n + string.length());
                    this.index = n;
                } else {
                    if (this.index != 0 && this.wrapbox.isSelected()) {
                        this.index = 0;
                        this.findnext(string);
                    } else {
                        CommTrace.error(this.find, "Error", "Text not found");
                    }
                    n = 0;
                }
            }
        }
        this.index = n;
        this.find.invalidate();
        this.find.validate();
        this.find.repaint();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.find) {
            this.close();
        }
    }

    public void close() {
        this.isClosed = true;
        this.find.setVisible(false);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getSource() == this.fnext) {
            if (n == 10) {
                this.findnext(this.input.getText());
            }
        } else if (keyEvent.getSource() == this.cancel && n == 10) {
            this.isClosed = true;
            this.find.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

