/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import java.awt.List;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

class IFSList
extends List
implements IFSFileFilter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private AS400 sys_;
    private String path_ = "/";
    private String filter_ = "*";
    private boolean sort_ = true;
    private IFSFile ifsFile_;
    private int directory_ = 1;
    private Vector fList;
    private Vector actionEventList = new Vector();
    private Vector errorEventList = new Vector();
    private PropertyChangeSupport propertyList = new PropertyChangeSupport(this);
    public static final int DIRECTORYONLY = 1;
    public static final int FILEONLY = 2;
    public static final int BOTH = 3;

    @Override
    public boolean accept(IFSFile iFSFile) {
        boolean bl = false;
        try {
            switch (this.directory_) {
                case 1: {
                    if (iFSFile.isDirectory()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (iFSFile.isFile()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            this.fireError(iOException, "accept");
            return false;
        }
        if (bl) {
            if (this.sort_) {
                int n;
                for (n = 0; n < this.fList.size(); ++n) {
                    String string = (String)this.fList.elementAt(n);
                    if (string.toUpperCase().compareTo(iFSFile.getName().toUpperCase()) <= 0) continue;
                    this.fList.insertElementAt(iFSFile.getName(), n);
                    break;
                }
                if (n == this.fList.size()) {
                    this.fList.addElement(iFSFile.getName());
                }
            } else {
                this.add(iFSFile.getName());
            }
        }
        return bl;
    }

    public synchronized void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionEventList.addElement(actionCompletedListener);
    }

    public synchronized void addErrorListener(ErrorListener errorListener) {
        this.errorEventList.addElement(errorListener);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyList.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAction(String string) {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.actionEventList.clone();
        }
        serializable = new ActionCompletedEvent(this);
        for (int i = 0; i < vector.size(); ++i) {
            ActionCompletedListener actionCompletedListener = (ActionCompletedListener)vector.elementAt(i);
            actionCompletedListener.actionCompleted((ActionCompletedEvent)serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireError(Exception exception, String string) {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.errorEventList.clone();
        }
        serializable = new ErrorEvent(this, exception);
        for (int i = 0; i < vector.size(); ++i) {
            ErrorListener errorListener = (ErrorListener)vector.elementAt(i);
            errorListener.errorOccurred((ErrorEvent)serializable);
        }
    }

    public String getFilter() {
        return this.filter_;
    }

    public String getPath() {
        return this.path_;
    }

    public boolean isSort() {
        return this.sort_;
    }

    public int getListType() {
        return this.directory_;
    }

    public AS400 getSystem() {
        return this.sys_;
    }

    public void populateList() throws IOException {
        this.setVisible(false);
        this.removeAll();
        this.setVisible(true);
        if (this.sys_ == null) {
            this.sys_ = new AS400();
        }
        if (this.ifsFile_ == null) {
            this.ifsFile_ = new IFSFile(this.sys_, this.path_);
        }
        if (this.directory_ == 1 || this.directory_ == 3) {
            this.add(".");
            this.add("..");
        }
        this.fList = new Vector();
        if (this.filter_ != null) {
            this.ifsFile_.list(this, this.filter_);
        } else {
            this.ifsFile_.list(this);
        }
        for (int i = 0; i < this.fList.size(); ++i) {
            this.add((String)this.fList.elementAt(i));
        }
        this.fireAction("populateList");
    }

    public void setFilter(String string) {
        String string2 = this.filter_;
        this.filter_ = string.compareTo("*.*") == 0 ? "*" : string;
        this.propertyList.firePropertyChange("filter", string2, this.filter_);
    }

    public void setListType(int n) {
        Integer n2 = new Integer(this.directory_);
        this.directory_ = n;
        this.propertyList.firePropertyChange("listType", n2, new Integer(n));
    }

    public void setPath(String string) {
        String string2 = this.path_;
        this.path_ = string;
        this.ifsFile_ = null;
        this.propertyList.firePropertyChange("path", string2, this.path_);
    }

    public void setSort(boolean bl) {
        Boolean bl2 = new Boolean(this.sort_);
        this.sort_ = bl;
        this.propertyList.firePropertyChange("sort", bl2, new Boolean(this.sort_));
    }

    public void setSystem(AS400 aS400) {
        AS400 aS4002 = this.sys_;
        this.sys_ = aS400;
        this.propertyList.firePropertyChange("system", aS4002, this.sys_);
    }
}

