/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Closure;

public class LearningEvaluator
implements SequenceEvaluator {
    private static final int EVAL_LIMIT = 20;
    private final Expression expression;
    private SequenceEvaluator evaluator;
    private int completed = 0;
    private int count = 0;
    private boolean flipped;

    public LearningEvaluator(Expression expr, SequenceEvaluator lazy) {
        this.expression = expr;
        this.evaluator = lazy;
    }

    @Override
    public Sequence evaluate(XPathContext context) throws XPathException {
        if (this.count > 20) {
            return this.evaluator.evaluate(context);
        }
        Sequence result = this.evaluator.evaluate(context);
        if (result instanceof Closure) {
            ((Closure)result).setLearningEvaluator(this, this.count);
        } else {
            this.flipped = true;
        }
        ++this.count;
        return result;
    }

    public void reportCompletion(int serialNumber) {
        if (this.completed++ >= 20 && this.completed == this.count) {
            this.evaluator = this.expression.makeElaborator().eagerly();
            this.count = Integer.MAX_VALUE;
            this.flipped = true;
        }
    }

    public boolean hasDecidedToEvaluateEagerly() {
        return this.flipped;
    }
}

