/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.SequenceType;

public class AbsentExtensionElement
extends StyleElement {
    CallTemplate instruction;
    boolean useTailRecursion;

    @Override
    public boolean isInXsltNamespace() {
        return this.getNodeName().hasURI(NamespaceUri.XSLT);
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void processAllAttributes() throws XPathException {
        PrincipalStylesheetModule pack;
        NamedTemplate template;
        if (this.reportingCircumstances == StyleElement.OnFailure.IGNORED_INSTRUCTION) {
            return;
        }
        if (this.reportingCircumstances == StyleElement.OnFailure.REPORT_ALWAYS) {
            this.compileError(this.validationError);
        }
        if (this.getEffectiveVersion() >= 40 && !this.isInXsltNamespace() && (template = (pack = this.getPrincipalStylesheetModule()).getNamedTemplate(this.getNodeName().getStructuredQName())) != null) {
            CallTemplate insn = new CallTemplate(template, template.getTemplateName(), false, ((StyleElement)this.getParent()).isWithinDeclaredStreamableConstruct());
            List<NamedTemplate.LocalParamInfo> declaredParams = template.getLocalParamDetails();
            for (NamedTemplate.LocalParamInfo param : declaredParams) {
                if (!param.isRequired || param.isTunnel || this.attributes().get(param.name.getNamespaceUri(), param.name.getLocalPart()) != null) continue;
                this.compileError("No value supplied for required parameter " + Err.wrap(param.name.getDisplayName(), 5), "XTSE0690");
            }
            ArrayList<WithParam> params = new ArrayList<WithParam>();
            for (AttributeInfo att : this.attributes().asList()) {
                StructuredQName name = att.getNodeName().getStructuredQName();
                if (name.hasURI(NamespaceUri.XSLT) || name.hasURI(NamespaceUri.XML)) continue;
                for (NamedTemplate.LocalParamInfo param : declaredParams) {
                    if (!param.name.equals(name) || param.isTunnel) continue;
                    SequenceType required = param.requiredType;
                    WithParam withParam = new WithParam();
                    withParam.setVariableQName(name);
                    withParam.setRequiredType(SequenceType.ANY_SEQUENCE);
                    if (required.getCardinality() == 16384 && required.getPrimaryType().isPlainType()) {
                        Expression avt;
                        if (required.getPrimaryType() == BuiltInAtomicType.BOOLEAN) {
                            avt = this.makeAttributeValueTemplate(att.getValue(), att);
                            Expression toBool = VendorFunctionSetHE.getInstance().makeFunction("yes-no-boolean", 1).makeFunctionCall(avt);
                            withParam.setSelectExpression(insn, toBool);
                        } else {
                            avt = this.makeAttributeValueTemplate(att.getValue(), att);
                            if (required.getPrimaryType() != BuiltInAtomicType.STRING) {
                                avt = new AtomicSequenceConverter(avt, BuiltInAtomicType.UNTYPED_ATOMIC);
                            }
                            withParam.setSelectExpression(insn, avt);
                        }
                    } else {
                        Expression select = this.makeExpression(att.getValue(), att);
                        withParam.setSelectExpression(insn, select);
                    }
                    params.add(withParam);
                }
            }
            insn.setActualParameters(params.toArray(new WithParam[0]), new WithParam[0]);
            this.instruction = insn;
        }
        if (!this.isTopLevel() || !this.forwardsCompatibleModeIsEnabled()) {
            super.processAllAttributes();
        }
    }

    @Override
    protected void prepareAttributes() {
    }

    @Override
    protected boolean markTailCalls() {
        this.useTailRecursion = true;
        if (this.instruction != null) {
            this.instruction.setTailRecursive(true);
        }
        return true;
    }

    @Override
    public void validateSubtree(ComponentDeclaration decl, boolean excludeStylesheet) throws XPathException {
        if (!(this.reportingCircumstances == StyleElement.OnFailure.IGNORED_INSTRUCTION || this.isTopLevel() && this.forwardsCompatibleModeIsEnabled())) {
            super.validateSubtree(decl, excludeStylesheet);
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.instruction != null) {
            return this.instruction;
        }
        if (this.isTopLevel() || this.reportingCircumstances == StyleElement.OnFailure.IGNORED_INSTRUCTION) {
            return null;
        }
        if (this.validationError == null) {
            this.validationError = new XmlProcessingIncident("Unknown instruction");
        }
        return this.fallbackProcessing(exec, decl, this);
    }
}

