////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2018-2023 Saxonica Limited
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
// This Source Code Form is "Incompatible With Secondary Licenses", as defined by the Mozilla Public License, v. 2.0.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/**
 * <p>This package provides utility routines for handling integer sets and maps.</p>
 * <p>The main classes are <code>IntSet</code> which represents a set of 32-bit integers
 * (int values), <code>IntIterator</code> which is an iterator over a sequence of 32-bit
 * integers, <code>IntHashMap</code> which is a map from 32-bit integers to arbitrary
 * objects, and <code>IntToIntMap</code> which is a map from 32-bit integers to 32-bit
 * integers.</p>
 * <p>The package name is a pun on the conventional use by mathematicians
 * of the symbol <b>Z</b> to denote the set of all natural integers.</p>
 */
package net.sf.saxon.z;
