/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorHandler;
import net.sf.saxon.lib.StandardErrorReporter;
import net.sf.saxon.s9api.XmlProcessingError;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class ActiveSAXSource
extends SAXSource
implements ActiveSource {
    Consumer<XMLReader> parserPool;

    public ActiveSAXSource(XMLReader parser, InputSource source) {
        super(parser, source);
    }

    public ActiveSAXSource(SAXSource source) throws IllegalArgumentException, XPathException {
        if (source.getXMLReader() == null) {
            throw new IllegalArgumentException("Supplied SAXSource contains no XMLReader");
        }
        this.setInputSource(source.getInputSource());
        this.setXMLReader(source.getXMLReader());
        this.setSystemId(source.getSystemId());
    }

    public ActiveSAXSource(InputSource inputSource, Configuration config) {
        this.setInputSource(inputSource);
        this.setXMLReader(config.getSourceParser());
        this.setSystemId(inputSource.getSystemId());
    }

    public void setParserPool(Consumer<XMLReader> parserPool) {
        this.parserPool = parserPool;
    }

    @Override
    public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
        ErrorHandler errorHandler = null;
        try {
            boolean xInclude;
            Logger logger = receiver.getPipelineConfiguration().getConfiguration().getLogger();
            XMLReader parser = this.getXMLReader();
            ActiveSAXSource.configureParser(parser);
            ReceivingContentHandler rch = new ReceivingContentHandler();
            rch.setReceiver(receiver);
            rch.setPipelineConfiguration(receiver.getPipelineConfiguration());
            parser.setContentHandler(rch);
            parser.setDTDHandler(rch);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", rch);
            errorHandler = parser.getErrorHandler();
            if (errorHandler == null) {
                errorHandler = options.getErrorHandler();
                if (errorHandler == null) {
                    errorHandler = options.getErrorReporter() != null ? new StandardErrorHandler(options.getErrorReporter()) : new StandardErrorHandler(receiver.getPipelineConfiguration().getConfiguration().makeErrorReporter());
                }
                parser.setErrorHandler(errorHandler);
            }
            if (!options.isExpandAttributeDefaults()) {
                try {
                    parser.setFeature("http://xml.org/sax/features/use-attributes2", true);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                    // empty catch block
                }
            }
            boolean dtdRecover = options.getDTDValidationMode() == 2;
            Map<String, Boolean> parserFeatures = options.getParserFeatures();
            Map<String, Object> parserProperties = options.getParserProperties();
            if (parserFeatures != null) {
                for (Map.Entry<String, Object> entry : parserFeatures.entrySet()) {
                    try {
                        String name = entry.getKey();
                        boolean value = (Boolean)entry.getValue();
                        if (name.equals("http://apache.org/xml/features/xinclude")) {
                            boolean tryAgain = false;
                            try {
                                parser.setFeature(name, value);
                            }
                            catch (SAXNotRecognizedException | SAXNotSupportedException err) {
                                tryAgain = true;
                            }
                            if (!tryAgain) continue;
                            try {
                                parser.setFeature(name + "-aware", value);
                                continue;
                            }
                            catch (SAXNotRecognizedException err) {
                                throw new XPathException(ActiveSAXSource.namedParser(parser) + " does not recognize request for XInclude processing", err);
                            }
                            catch (SAXNotSupportedException err) {
                                throw new XPathException(ActiveSAXSource.namedParser(parser) + " does not support XInclude processing", err);
                            }
                        }
                        parser.setFeature(name, value);
                    }
                    catch (SAXNotRecognizedException err) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        logger.warning(ActiveSAXSource.namedParser(parser) + " does not recognize the feature " + entry.getKey());
                    }
                    catch (SAXNotSupportedException err) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        logger.warning(ActiveSAXSource.namedParser(parser) + " does not support the feature " + entry.getKey());
                    }
                }
            }
            if (parserProperties != null) {
                for (Map.Entry<String, Object> entry : parserProperties.entrySet()) {
                    try {
                        parser.setProperty(entry.getKey(), entry.getValue());
                    }
                    catch (SAXNotRecognizedException err) {
                        logger.warning(ActiveSAXSource.namedParser(parser) + " does not recognize the property " + entry.getKey());
                    }
                    catch (SAXNotSupportedException err) {
                        logger.warning(ActiveSAXSource.namedParser(parser) + " does not support the property " + entry.getKey());
                    }
                }
            }
            if (xInclude = options.isXIncludeAware()) {
                boolean bl;
                boolean bl2 = false;
                try {
                    parser.setFeature("http://apache.org/xml/features/xinclude-aware", true);
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException err) {
                    bl = true;
                }
                if (bl) {
                    try {
                        parser.setFeature("http://apache.org/xml/features/xinclude", true);
                    }
                    catch (SAXNotRecognizedException err) {
                        throw new XPathException(ActiveSAXSource.namedParser(parser) + " does not recognize request for XInclude processing", err);
                    }
                    catch (SAXNotSupportedException err) {
                        throw new XPathException(ActiveSAXSource.namedParser(parser) + " does not support XInclude processing", err);
                    }
                }
            }
            parser.parse(this.getInputSource());
            if (errorHandler instanceof StandardErrorHandler) {
                int n = ((StandardErrorHandler)errorHandler).getFatalErrorCount();
                if (n > 0) {
                    throw new XPathException("The XML parser reported " + n + (n == 1 ? " error" : " errors"));
                }
                int n2 = ((StandardErrorHandler)errorHandler).getErrorCount();
                if (n2 > 0) {
                    String message = "The XML parser reported " + new Numberer_en().toWords("", n2).toLowerCase() + " validation error" + (n2 == 1 ? "" : "s");
                    if (dtdRecover) {
                        message = message + ". Processing continues, because recovery from validation errors was requested";
                        logger.warning(message);
                    } else {
                        throw new XPathException(message);
                    }
                }
            }
            if (this.parserPool != null) {
                this.parserPool.accept(this.getXMLReader());
            }
        }
        catch (XPathException xpe) {
            throw xpe;
        }
        catch (UncheckedXPathException uxpe) {
            throw uxpe.getXPathException();
        }
        catch (SAXException err) {
            StandardErrorReporter ser;
            XmlProcessingError latestError;
            StandardErrorHandler seh;
            ErrorReporter er;
            Exception nested = err.getException();
            if (nested instanceof XPathException) {
                throw (XPathException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            if (errorHandler instanceof StandardErrorHandler && (er = (seh = (StandardErrorHandler)errorHandler).getErrorReporter()) instanceof StandardErrorReporter && (latestError = (ser = (StandardErrorReporter)er).getLatestError()) != null) {
                throw new XPathException(ser.getExpandedMessage(latestError)).withErrorCode("SXXP0003").withLocation(latestError.getLocation());
            }
            XPathException de = new XPathException(err).withErrorCode("SXXP0003");
            de.setHasBeenReported(true);
            throw de;
        }
        catch (IOException err) {
            throw new XPathException("I/O error reported by XML parser processing " + this.getSystemId(), err).withErrorCode("SXXP0003");
        }
    }

    private static String namedParser(XMLReader parser) {
        return "Selected XML parser " + parser.getClass().getName();
    }

    public static void configureParser(XMLReader parser) throws XPathException {
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespaces' feature", err);
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespaces' feature to true", err);
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespace-prefixes' feature", err);
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespace-prefixes' feature to false", err);
        }
    }
}

