/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.value.SequenceType;

public class OperandRole {
    public static final int SETS_NEW_FOCUS = 1;
    public static final int USES_NEW_FOCUS = 2;
    public static final int HIGHER_ORDER = 4;
    public static final int IN_CHOICE_GROUP = 8;
    public static final OperandRole SAME_FOCUS_ACTION = new OperandRole(0, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole FOCUS_CONTROLLING_SELECT = new OperandRole(1, OperandUsage.INSPECTION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole FOCUS_CONTROLLED_ACTION = new OperandRole(6, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole INSPECT = new OperandRole(0, OperandUsage.INSPECTION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole REPEAT_INSPECT = new OperandRole(4, OperandUsage.INSPECTION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole NAVIGATE = new OperandRole(0, OperandUsage.NAVIGATION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole REPEAT_NAVIGATE = new OperandRole(4, OperandUsage.NAVIGATION, SequenceType.ANY_SEQUENCE);
    public static final OperandRole SINGLE_ATOMIC = new OperandRole(0, OperandUsage.ABSORPTION, SequenceType.SINGLE_ATOMIC);
    public static final OperandRole ATOMIC_SEQUENCE = new OperandRole(0, OperandUsage.ABSORPTION, SequenceType.ATOMIC_SEQUENCE);
    public static final OperandRole NEW_FOCUS_ATOMIC = new OperandRole(6, OperandUsage.ABSORPTION, SequenceType.ATOMIC_SEQUENCE);
    int properties;
    private OperandUsage usage;
    private SequenceType requiredType = SequenceType.ANY_SEQUENCE;

    public OperandRole(int properties, OperandUsage usage) {
        this.properties = properties;
        this.usage = usage;
    }

    public OperandRole(int properties, OperandUsage usage, SequenceType requiredType) {
        this.properties = properties;
        this.usage = usage;
        this.requiredType = requiredType;
    }

    public boolean setsNewFocus() {
        return (this.properties & 1) != 0;
    }

    public boolean hasSameFocus() {
        return (this.properties & 2) == 0;
    }

    public boolean isEvaluatedRepeatedly() {
        return (this.properties & 4) != 0;
    }

    public OperandUsage getUsage() {
        return this.usage;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public boolean isInChoiceGroup() {
        return (this.properties & 8) != 0;
    }

    public static OperandUsage getTypeDeterminedUsage(ItemType type) {
        if (type instanceof FunctionItemType) {
            return OperandUsage.INSPECTION;
        }
        if (type instanceof PlainType) {
            return OperandUsage.ABSORPTION;
        }
        return OperandUsage.NAVIGATION;
    }
}

