/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.value.ObjectValue;

public class CollectionFn
extends SystemFunction
implements Callable {
    public static String EMPTY_COLLECTION_URI = "http://saxon.sf.net/collection/empty";
    public static final ResourceCollection EMPTY_COLLECTION = new EmptyCollection(EMPTY_COLLECTION_URI);

    public int getSpecialProperties(Expression[] arguments) {
        return super.getSpecialProperties(arguments) & 0xFFBFFFFF | 0x80000;
    }

    private String getAbsoluteCollectionURI(String href, XPathContext context) throws XPathException {
        String absoluteURI;
        block6: {
            if (href == null) {
                absoluteURI = context.getConfiguration().getDefaultCollection();
            } else {
                try {
                    URI uri = new URI(href);
                    if (uri.isAbsolute()) {
                        absoluteURI = uri.toString();
                        break block6;
                    }
                    String base = this.getRetainedStaticContext().getStaticBaseUriString();
                    if (base != null) {
                        absoluteURI = new URI(base).resolve(href).toString();
                        break block6;
                    }
                    throw new XPathException("Relative collection URI cannot be resolved: no base URI available", "FODC0002");
                }
                catch (URISyntaxException e) {
                    throw new XPathException(e.getMessage(), "FODC0004");
                }
            }
        }
        return absoluteURI;
    }

    private SequenceIterator getSequenceIterator(final ResourceCollection collection, final XPathContext context) throws XPathException {
        final Iterator<? extends Resource> sources = collection.getResources(context);
        return new SequenceIterator(){

            public Item next() {
                if (sources.hasNext()) {
                    return new ObjectValue(sources.next());
                }
                return null;
            }

            public void close() {
            }

            public int getProperties() {
                return 0;
            }

            public SequenceIterator getAnother() throws XPathException {
                return CollectionFn.this.getSequenceIterator(collection, context);
            }
        };
    }

    public Sequence call(final XPathContext context, Sequence[] arguments) throws XPathException {
        boolean alreadyStripped;
        GroundedValue cachedCollection;
        Item arg;
        String href = this.getArity() == 0 ? context.getController().getDefaultCollection() : ((arg = arguments[0].head()) == null ? context.getController().getDefaultCollection() : arg.getStringValue());
        if (href == null) {
            throw new XPathException("No default collection has been defined", "FODC0002");
        }
        String absoluteURI = this.getAbsoluteCollectionURI(href, context);
        PackageData packageData = this.getRetainedStaticContext().getPackageData();
        SpaceStrippingRule whitespaceRule = NoElementsSpaceStrippingRule.getInstance();
        String collectionKey = absoluteURI;
        if (packageData instanceof StylesheetPackage && (whitespaceRule = ((StylesheetPackage)packageData).getSpaceStrippingRule()) != NoElementsSpaceStrippingRule.getInstance()) {
            collectionKey = ((StylesheetPackage)packageData).getPackageName() + ((StylesheetPackage)packageData).getPackageVersion() + " " + absoluteURI;
        }
        if ((cachedCollection = (GroundedValue)context.getController().getUserData("saxon:collections", collectionKey)) != null) {
            return cachedCollection;
        }
        CollectionFinder collectionFinder = context.getController().getCollectionFinder();
        ResourceCollection collection = collectionFinder.findCollection(context, absoluteURI);
        if (collection == null) {
            collection = new EmptyCollection(EMPTY_COLLECTION_URI);
        }
        if (packageData instanceof StylesheetPackage && whitespaceRule != NoElementsSpaceStrippingRule.getInstance() && collection instanceof AbstractResourceCollection && (alreadyStripped = ((AbstractResourceCollection)collection).stripWhitespace(whitespaceRule))) {
            whitespaceRule = null;
        }
        SequenceIterator sourceSeq = this.getSequenceIterator(collection, context);
        ItemMappingIterator<Item, Item> result = context.getConfiguration().getMultithreadedItemMappingIterator(sourceSeq, new ItemMappingFunction<ObjectValue<Resource>, Item>(){

            @Override
            public Item mapItem(ObjectValue<Resource> item1) throws XPathException {
                return item1.getObject().getItem(context);
            }
        });
        if (this.getRetainedStaticContext().getXPathVersion() <= 30) {
            RoleDiagnostic role = new RoleDiagnostic(5, "collection", 0);
            ItemTypeCheckingFunction function = new ItemTypeCheckingFunction(AnyNodeTest.getInstance(), role, null, context.getConfiguration());
            result = new ItemMappingIterator(result, function, true);
        }
        if (whitespaceRule != null) {
            final SpaceStrippingRule rule = whitespaceRule;
            ItemMappingFunction<Item, Item> stripper = new ItemMappingFunction<Item, Item>(){

                @Override
                public Item mapItem(Item item) throws XPathException {
                    if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 9) {
                        SpaceStrippedDocument ssd = new SpaceStrippedDocument(((NodeInfo)item).getTreeInfo(), rule);
                        return ssd.getRootNode();
                    }
                    return item;
                }
            };
            result = new ItemMappingIterator<Item, Item>(result, stripper);
        }
        if (collection.isStable(context) || context.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/stableCollectionUri")) {
            Item item;
            Controller controller = context.getController();
            DocumentPool docPool = controller.getDocumentPool();
            cachedCollection = SequenceTool.toGroundedValue(result);
            UnfailingIterator iter = cachedCollection.iterate();
            while ((item = iter.next()) != null) {
                if (!(item instanceof NodeInfo) || ((NodeInfo)item).getNodeKind() != 9) continue;
                String docUri = ((NodeInfo)item).getSystemId();
                DocumentURI docKey = new DocumentURI(docUri);
                TreeInfo info = item instanceof TreeInfo ? (TreeInfo)((Object)item) : new GenericTreeInfo(controller.getConfiguration(), (NodeInfo)item);
                docPool.add(info, docKey);
            }
            context.getController().setUserData("saxon:collections", collectionKey, cachedCollection);
            return cachedCollection;
        }
        return new LazySequence(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyCollection
    implements ResourceCollection {
        private String collectionUri;

        public EmptyCollection(String cUri) {
            this.collectionUri = cUri;
        }

        @Override
        public String getCollectionURI() {
            return this.collectionUri;
        }

        @Override
        public Iterator<String> getResourceURIs(XPathContext context) throws XPathException {
            return new ArrayList().iterator();
        }

        public Iterator<Resource> getResources(XPathContext context) throws XPathException {
            return new ArrayList().iterator();
        }

        @Override
        public boolean isStable(XPathContext context) {
            return true;
        }
    }
}

