/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.ParseXml;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ParseXmlFragment
extends SystemFunction
implements Callable {
    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.evalParseXml((StringValue)arguments[0].head(), context);
    }

    private NodeInfo evalParseXml(StringValue inputArg, XPathContext context) throws XPathException {
        NodeInfo node;
        final String baseURI = this.getStaticBaseUriString();
        ParseXml.RetentiveErrorHandler errorHandler = new ParseXml.RetentiveErrorHandler();
        try {
            Controller controller = context.getController();
            if (controller == null) {
                throw new XPathException("parse-xml-fragment() function is not available in this environment");
            }
            Configuration configuration = controller.getConfiguration();
            final StringReader fragmentReader = new StringReader(inputArg.getStringValue());
            String skeleton = "<!DOCTYPE z [<!ENTITY e SYSTEM \"http://www.saxonica.com/parse-xml-fragment/actual.xml\">]>\n<z>&e;</z>";
            StringReader skeletonReader = new StringReader(skeleton);
            InputSource is = new InputSource(skeletonReader);
            is.setSystemId(baseURI);
            SAXSource source = new SAXSource(is);
            XMLReader reader = configuration.getSourceParser();
            if (reader.getEntityResolver() != null) {
                try {
                    reader = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException e) {
                    throw new XPathException(e);
                }
            }
            source.setXMLReader(reader);
            source.setSystemId(baseURI);
            Builder b = controller.makeBuilder();
            if (b instanceof TinyBuilder) {
                ((TinyBuilder)b).setStatistics(Statistics.FN_PARSE_STATISTICS);
            }
            Receiver s = b;
            ParseOptions options = new ParseOptions();
            reader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if ("http://www.saxonica.com/parse-xml-fragment/actual.xml".equals(systemId)) {
                        InputSource is = new InputSource(fragmentReader);
                        is.setSystemId(baseURI);
                        return is;
                    }
                    return null;
                }
            });
            options.setStripSpace(4);
            options.setErrorHandler(errorHandler);
            if (controller.getExecutable().stripsInputTypeAnnotations()) {
                s = configuration.getAnnotationStripper(s);
            }
            s.setPipelineConfiguration(b.getPipelineConfiguration());
            options.addFilter(new FilterFactory(){

                public ProxyReceiver makeFilter(Receiver next) {
                    return new OuterElementStripper(next);
                }
            });
            Sender.send(source, s, options);
            node = b.getCurrentRoot();
            b.reset();
        }
        catch (XPathException err) {
            XPathException xe = new XPathException("First argument to parse-xml-fragment() is not a well-formed and namespace-well-formed XML fragment. XML parser reported: " + err.getMessage(), "FODC0006");
            errorHandler.captureRetainedErrors(xe);
            xe.maybeSetContext(context);
            throw xe;
        }
        return node;
    }

    private static class OuterElementStripper
    extends ProxyReceiver {
        private int level = 0;
        private boolean suppressStartContent = false;

        public OuterElementStripper(Receiver next) {
            super(next);
        }

        public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
            if (this.level > 0) {
                super.startElement(elemName, typeCode, location, properties);
            } else {
                this.suppressStartContent = true;
            }
            ++this.level;
        }

        public void startContent() throws XPathException {
            if (!this.suppressStartContent) {
                super.startContent();
            }
            this.suppressStartContent = false;
        }

        public void endElement() throws XPathException {
            --this.level;
            if (this.level > 0) {
                super.endElement();
            }
        }
    }
}

