/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleTarget;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRule
implements RuleTarget,
Location {
    private Expression body;
    private Pattern matchPattern;
    private boolean hasRequiredParams;
    private boolean bodyIsTailCallReturner;
    private SequenceType requiredType;
    private boolean declaredStreamable;
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private boolean mayOmitContextItem = true;
    private boolean maySupplyContextItem = true;
    private SlotManager stackFrameMap;
    private PackageData packageData;
    private String systemId;
    private int lineNumber;
    private List<Rule> rules = new ArrayList<Rule>();
    private List<TemplateRule> slaveCopies = new ArrayList<TemplateRule>();

    public void setMatchPattern(Pattern pattern) {
        this.matchPattern = pattern;
    }

    public Expression getBody() {
        return this.body;
    }

    public void setContextItemRequirements(ItemType type, boolean mayBeOmitted, boolean mayBeSupplied) {
        this.requiredContextItemType = type;
        this.mayOmitContextItem = mayBeOmitted;
        this.maySupplyContextItem = mayBeSupplied;
    }

    public int getComponentKind() {
        return 200;
    }

    public Pattern getMatchPattern() {
        return this.matchPattern;
    }

    public void setBody(Expression body) {
        this.body = body;
        this.bodyIsTailCallReturner = body instanceof TailCallReturner;
    }

    public void setStackFrameMap(SlotManager map) {
        this.stackFrameMap = map;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public void setHasRequiredParams(boolean has) {
        this.hasRequiredParams = has;
    }

    public boolean hasRequiredParams() {
        return this.hasRequiredParams;
    }

    public void setRequiredType(SequenceType type) {
        this.requiredType = type;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.requiredType;
    }

    @Override
    public void registerRule(Rule rule) {
        this.rules.add(rule);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setDeclaredStreamable(boolean streamable) {
        this.declaredStreamable = streamable;
    }

    public boolean isDeclaredStreamable() {
        return this.declaredStreamable;
    }

    public int getContainerGranularity() {
        return 0;
    }

    public PackageData getPackageData() {
        return this.packageData;
    }

    public void setPackageData(PackageData data) {
        this.packageData = data;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public boolean isMayOmitContextItem() {
        return this.mayOmitContextItem;
    }

    public boolean isMaySupplyContextItem() {
        return this.maySupplyContextItem;
    }

    public List<LocalParam> getLocalParams() {
        ArrayList<LocalParam> result = new ArrayList<LocalParam>();
        TemplateRule.gatherLocalParams(this.getInterpretedBody(), result);
        return result;
    }

    private static void gatherLocalParams(Expression exp, List<LocalParam> result) {
        if (exp instanceof LocalParamSetter) {
            result.add(((LocalParamSetter)exp).getBinding());
        } else {
            for (Operand o : exp.operands()) {
                TemplateRule.gatherLocalParams(o.getChildExpression(), result);
            }
        }
    }

    public LocalParam getLocalParam(StructuredQName id) {
        for (Operand o : this.body.operands()) {
            LocalParam lp;
            Expression child = o.getChildExpression();
            if (child instanceof LocalParamSetter && ((LocalParamSetter)child).getBinding().getVariableQName().equals(id)) {
                return ((LocalParamSetter)child).getBinding();
            }
            if (!ExpressionTool.containsLocalParam(child) || (lp = TemplateRule.getLocalParam(child, id)) == null) continue;
            return lp;
        }
        return null;
    }

    private static LocalParam getLocalParam(Expression exp, StructuredQName id) {
        for (Operand o : exp.operands()) {
            Expression child = o.getChildExpression();
            if (child instanceof LocalParamSetter && ((LocalParamSetter)child).getBinding().getVariableQName().equals(id)) {
                return ((LocalParamSetter)child).getBinding();
            }
            if (!ExpressionTool.containsLocalParam(child)) continue;
            return TemplateRule.getLocalParam(child, id);
        }
        return null;
    }

    public void apply(XPathContextMajor context) throws XPathException {
        for (TailCall tc = this.applyLeavingTail(context); tc != null; tc = tc.processLeavingTail()) {
        }
    }

    public TailCall applyLeavingTail(XPathContext context) throws XPathException {
        if (this.requiredContextItemType != AnyItemType.getInstance() && !this.requiredContextItemType.matches(context.getContextItem(), context.getConfiguration().getTypeHierarchy())) {
            XPathException err = new XPathException("The template requires a context item of type " + this.requiredContextItemType + ", but the supplied context item has type " + Type.getItemType(context.getContextItem(), context.getConfiguration().getTypeHierarchy()), "XTTE0590");
            err.setLocation(this);
            err.setIsTypeError(true);
            throw err;
        }
        if (!this.maySupplyContextItem) {
            context = context.newMinorContext();
            context.setCurrentIterator(null);
        }
        try {
            if (this.bodyIsTailCallReturner) {
                return ((TailCallReturner)((Object)this.body)).processLeavingTail(context);
            }
            this.body.process(context);
            return null;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
        catch (Exception e2) {
            String message = "Internal error evaluating template rule " + (this.getLineNumber() > 0 ? " at line " + this.getLineNumber() : "") + (this.getSystemId() != null ? " in module " + this.getSystemId() : "");
            throw new RuntimeException(message, e2);
        }
    }

    public int getConstructType() {
        return 2008;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("template");
        this.explainProperties(presenter);
        presenter.emitAttribute("slots", "" + this.getStackFrameMap().getNumberOfVariables());
        if (this.matchPattern != null) {
            presenter.setChildRole("match");
            this.matchPattern.export(presenter);
        }
        if (this.getBody() != null) {
            presenter.setChildRole("body");
            this.getBody().export(presenter);
        }
        presenter.endElement();
    }

    public void explainProperties(ExpressionPresenter presenter) {
        if (this.getRequiredContextItemType() != AnyItemType.getInstance()) {
            presenter.emitAttribute("cxt", this.getRequiredContextItemType().toString());
        }
        String flags = "";
        if (this.mayOmitContextItem) {
            flags = "o";
        }
        if (this.maySupplyContextItem) {
            flags = flags + "s";
        }
        presenter.emitAttribute("flags", flags);
        if (this.getRequiredType() != SequenceType.ANY_SEQUENCE) {
            presenter.emitAttribute("as", this.getRequiredType().toString());
        }
        presenter.emitAttribute("line", this.getLineNumber() + "");
        presenter.emitAttribute("module", this.getSystemId());
        if (this.isDeclaredStreamable()) {
            presenter.emitAttribute("streamable", "1");
        }
    }

    public Expression getInterpretedBody() {
        Expression original = this.body;
        return original;
    }

    public TemplateRule copy() {
        TemplateRule tr = new TemplateRule();
        if (this.body == null || this.matchPattern == null) {
            this.slaveCopies.add(tr);
        } else {
            this.copyTo(tr);
        }
        return tr;
    }

    public void updateSlaveCopies() {
        for (TemplateRule tr : this.slaveCopies) {
            this.copyTo(tr);
        }
    }

    private void copyTo(TemplateRule tr) {
        if (this.body != null) {
            tr.body = this.body.copy();
        }
        if (this.matchPattern != null) {
            tr.matchPattern = this.matchPattern.copy();
        }
        tr.hasRequiredParams = this.hasRequiredParams;
        tr.bodyIsTailCallReturner = this.bodyIsTailCallReturner;
        tr.requiredType = this.requiredType;
        tr.declaredStreamable = this.declaredStreamable;
        tr.requiredContextItemType = this.requiredContextItemType;
        tr.mayOmitContextItem = this.mayOmitContextItem;
        tr.maySupplyContextItem = this.maySupplyContextItem;
        tr.stackFrameMap = this.stackFrameMap;
        tr.packageData = this.packageData;
        tr.systemId = this.systemId;
        tr.lineNumber = this.lineNumber;
    }
}

