/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.json.JsonHandlerXML;
import net.sf.saxon.ma.json.JsonParser;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class JsonToXMLFn
extends SystemFunction {
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Item arg0 = arguments[0].head();
        if (arg0 == null) {
            return EmptySequence.getInstance();
        }
        String input = arg0.getStringValue();
        MapItem options = this.getArity() == 2 ? (MapItem)arguments[1].head() : new HashTrieMap(context);
        Item result = this.eval(input, options, context);
        return result == null ? EmptySequence.getInstance() : result;
    }

    protected Item eval(String input, MapItem options, XPathContext context) throws XPathException {
        JsonParser parser = new JsonParser(context.getConfiguration().getValidCharacterChecker());
        int flags = JsonParser.getFlags(options = JsonParser.checkOptions(options, context), context, true);
        if ((flags & 0x40) != 0) {
            throw new XPathException("json-to-xml: duplicates=use-last is not allowed", "FOJS0005");
        }
        if ((flags & 0x1E0) == 0) {
            flags = (flags & 8) != 0 ? (flags |= 0x100) : (flags |= 0x20);
        }
        JsonHandlerXML handler = new JsonHandlerXML(context, this.getStaticBaseUriString(), flags);
        handler.setFallbackFunction(options, context);
        parser.parse(input, flags, handler, context);
        return handler.getResult();
    }
}

