/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLPackage;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NestedIntegerValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compilation {
    public static final boolean TIMING = false;
    private Configuration config;
    private CompilerInfo compilerInfo;
    private int processorVersion;
    private PrincipalStylesheetModule principalStylesheetModule;
    private int errorCount = 0;
    private boolean schemaAware;
    private QNameParser qNameParser;
    private Map<StructuredQName, ValueAndPrecedence> staticVariables = new HashMap<StructuredQName, ValueAndPrecedence>();
    private Map<DocumentURI, TreeInfo> stylesheetModules = new HashMap<DocumentURI, TreeInfo>();
    private Stack<DocumentURI> importStack = new Stack();
    private PackageData packageData;

    public Compilation(Configuration config, CompilerInfo info) {
        this.config = config;
        this.compilerInfo = info;
        this.processorVersion = info.getXsltVersion();
        this.schemaAware = info.isSchemaAware();
        this.qNameParser = new QNameParser(null);
        this.qNameParser.setAcceptEQName(true);
        this.qNameParser.setDefaultNamespace("");
        this.qNameParser.setErrorOnBadSyntax("XTSE0020");
        this.qNameParser.setErrorOnUnresolvedPrefix("XTSE0280");
    }

    public static PreparedStylesheet compileSingletonPackage(Configuration config, CompilerInfo compilerInfo, Source source) throws XPathException {
        try {
            Compilation compilation = new Compilation(config, compilerInfo);
            return StylesheetModule.loadStylesheet(source, compilation);
        }
        catch (XPathException err) {
            if (!err.hasBeenReported()) {
                try {
                    compilerInfo.getErrorListener().fatalError(err);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw err;
        }
    }

    public void setPackageData(PackageData pack) {
        this.packageData = pack;
    }

    public void setMinimalPackageData() {
        if (this.getPackageData() == null) {
            PackageData pd = new PackageData(this.getConfiguration());
            pd.setXPathVersion(this.getProcessorVersion() == 30 ? 31 : this.getProcessorVersion());
            pd.setHostLanguage(50);
            pd.setTargetEdition(this.compilerInfo.getTargetEdition());
            this.packageData = pd;
        }
    }

    public PrincipalStylesheetModule compilePackage(Source source) throws XPathException {
        XSLPackage xslpackage;
        NodeInfo document;
        this.setMinimalPackageData();
        NodeInfo outermost = null;
        if (source instanceof NodeInfo) {
            NodeInfo root = (NodeInfo)source;
            if (root.getNodeKind() == 9) {
                document = root;
                outermost = document.iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
            } else if (root.getNodeKind() == 1) {
                document = root.getRoot();
                outermost = root;
            }
        }
        if (!(outermost instanceof XSLPackage)) {
            document = StylesheetModule.loadStylesheetModule(source, true, this, NestedIntegerValue.TWO);
            outermost = document.iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
        }
        if (outermost instanceof LiteralResultElement) {
            document = ((LiteralResultElement)outermost).makeStylesheet(true);
            outermost = document.iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
        }
        try {
            if (!(outermost instanceof XSLPackage)) {
                throw new XPathException("Outermost element must be xsl:package, xsl:stylesheet, or xsl:transform");
            }
            xslpackage = (XSLPackage)outermost;
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                try {
                    this.getCompilerInfo().getErrorListener().fatalError(e);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw e;
        }
        CompilerInfo info = this.getCompilerInfo();
        StyleNodeFactory factory = this.getStyleNodeFactory(true);
        PrincipalStylesheetModule psm = factory.newPrincipalModule(xslpackage);
        StylesheetPackage pack = psm.getStylesheetPackage();
        pack.setVersion(xslpackage.getVersion());
        pack.setPackageVersion(xslpackage.getPackageVersion());
        pack.setPackageName(xslpackage.getName());
        pack.setSchemaAware(info.isSchemaAware());
        pack.setXPathVersion(this.processorVersion >= 30 ? 31 : 20);
        pack.createFunctionLibrary();
        if (info.getExtensionFunctionLibrary() != null) {
            pack.getFunctionLibrary().addFunctionLibrary(info.getExtensionFunctionLibrary());
        }
        psm.getRuleManager().setRecoveryPolicy(info.getRecoveryPolicy());
        psm.getRuleManager().setCompilerInfo(info);
        this.setPrincipalStylesheetModule(psm);
        this.packageData = null;
        try {
            psm.preprocess();
        }
        catch (XPathException e) {
            try {
                info.getErrorListener().fatalError(e);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw e;
        }
        psm.findKeyablePatterns(this);
        if (this.getErrorCount() == 0) {
            try {
                psm.fixup();
            }
            catch (XPathException e) {
                this.reportError(e);
            }
        }
        if (this.getErrorCount() == 0) {
            try {
                psm.compile(this);
            }
            catch (XPathException e) {
                this.reportError(e);
            }
        }
        if (this.getErrorCount() == 0) {
            try {
                psm.complete();
            }
            catch (XPathException e) {
                this.reportError(e);
            }
        }
        return psm;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public CompilerInfo getCompilerInfo() {
        return this.compilerInfo;
    }

    public PackageData getPackageData() {
        if (this.packageData != null) {
            return this.packageData;
        }
        return this.principalStylesheetModule == null ? null : this.principalStylesheetModule.getStylesheetPackage();
    }

    public void setProcessorVersion(int v) {
        if (this.processorVersion == 0 && (v == 20 || v == 30)) {
            this.processorVersion = v;
            if (this.getPackageData() != null) {
                this.getPackageData().setXPathVersion(v);
            }
        }
    }

    public int getProcessorVersion() {
        return this.processorVersion;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    public void setSchemaAware(boolean schemaAware) {
        this.schemaAware = schemaAware;
        this.getPackageData().setSchemaAware(schemaAware);
    }

    public StyleNodeFactory getStyleNodeFactory(boolean topLevel) {
        StyleNodeFactory factory = this.getConfiguration().makeStyleNodeFactory(this);
        factory.setTopLevelModule(topLevel);
        return factory;
    }

    private void setPrincipalStylesheetModule(PrincipalStylesheetModule module) {
        this.principalStylesheetModule = module;
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.principalStylesheetModule;
    }

    public void reportError(XPathException err) {
        ErrorListener el = this.compilerInfo.getErrorListener();
        if (el == null) {
            el = this.getConfiguration().getErrorListener();
        }
        if (!err.hasBeenReported()) {
            ++this.errorCount;
            try {
                el.fatalError(err);
                err.setHasBeenReported(true);
            }
            catch (Exception exception) {}
        } else if (this.errorCount == 0) {
            ++this.errorCount;
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void reportWarning(XPathException err) {
        ErrorListener el = this.compilerInfo.getErrorListener();
        if (el == null) {
            el = this.getConfiguration().getErrorListener();
        }
        if (el != null) {
            try {
                el.warning(err);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void declareStaticVariable(StructuredQName name, GroundedValue value, NestedIntegerValue precedence) throws XPathException {
        ValueAndPrecedence vp = this.staticVariables.get(name);
        if (vp != null) {
            if (vp.precedence.compareTo(precedence) < 0) {
                if (!this.valuesAreCompatible(value, vp.value)) {
                    throw new XPathException("Incompatible values assigned for static variable " + name.getDisplayName(), "XTSE3450");
                }
            } else {
                return;
            }
        }
        this.staticVariables.put(name, new ValueAndPrecedence(value, precedence));
    }

    private boolean valuesAreCompatible(GroundedValue val0, GroundedValue val1) {
        if (val0.getLength() != val1.getLength()) {
            return false;
        }
        if (val0.getLength() == 1) {
            Item i0 = val0.head();
            Item i1 = val1.head();
            if (i0 instanceof AtomicValue) {
                return i1 instanceof AtomicValue && ((AtomicValue)i0).isIdentical((AtomicValue)i1);
            }
            if (i0 instanceof NodeInfo) {
                return i1 instanceof NodeInfo && ((NodeInfo)i0).isSameNodeInfo((NodeInfo)i1);
            }
            return i0 == i1;
        }
        for (int i = 0; i < val0.getLength(); ++i) {
            if (this.valuesAreCompatible((GroundedValue)((Object)val0.itemAt(i)), (GroundedValue)((Object)val1.itemAt(i)))) continue;
            return false;
        }
        return true;
    }

    public GroundedValue getStaticVariable(StructuredQName name) {
        ValueAndPrecedence vp = this.staticVariables.get(name);
        return vp == null ? null : vp.value;
    }

    public Map<DocumentURI, TreeInfo> getStylesheetModules() {
        return this.stylesheetModules;
    }

    public Stack<DocumentURI> getImportStack() {
        return this.importStack;
    }

    public QNameParser getQNameParser() {
        return this.qNameParser;
    }

    private static class ValueAndPrecedence {
        public GroundedValue value;
        public NestedIntegerValue precedence;

        public ValueAndPrecedence(GroundedValue v, NestedIntegerValue p) {
            this.value = v;
            this.precedence = p;
        }
    }
}

