/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.RECompiler;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.regex.charclass.EmptyCharacterClass;
import net.sf.saxon.regex.charclass.IntSetCharacterClass;
import net.sf.saxon.regex.charclass.SingletonCharacterClass;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntPredicate;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSetPredicate;
import net.sf.saxon.z.IntSingletonIterator;
import net.sf.saxon.z.IntSingletonSet;
import net.sf.saxon.z.IntStepIterator;

public abstract class Operation {
    public abstract IntIterator iterateMatches(REMatcher var1, int var2);

    public int getMatchLength() {
        return -1;
    }

    public int getMinimumMatchLength() {
        int fixed = this.getMatchLength();
        return fixed < 0 ? 0 : fixed;
    }

    public abstract boolean matchesEmptyString();

    public boolean containsCapturingExpressions() {
        return false;
    }

    public CharacterClass getInitialCharacterClass(boolean caseBlind) {
        return EmptyCharacterClass.getComplement();
    }

    public Operation optimize(REProgram program, REFlags flags) {
        return this;
    }

    public abstract String display();

    private static class ForceProgressIterator
    implements IntIterator {
        private IntIterator base;
        int countZeroLength = 0;
        int currentPos = -1;

        public ForceProgressIterator(IntIterator base) {
            this.base = base;
        }

        public boolean hasNext() {
            return this.countZeroLength <= 3 && this.base.hasNext();
        }

        public int next() {
            int p = this.base.next();
            if (p == this.currentPos) {
                ++this.countZeroLength;
            } else {
                this.countZeroLength = 0;
                this.currentPos = p;
            }
            return p;
        }
    }

    public static class OpTrace
    extends Operation {
        private Operation base;
        private static int counter = 0;

        public OpTrace(Operation base) {
            this.base = base;
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            final IntIterator baseIter = this.base.iterateMatches(matcher, position);
            final int iterNr = counter++;
            String clName = baseIter.getClass().getName();
            int lastDot = clName.lastIndexOf(".");
            String iterName = clName.substring(lastDot + 1);
            System.err.println("Iterating over " + this.base.getClass().getSimpleName() + " " + this.base.display() + " at position " + position + " returning " + iterName + " " + iterNr);
            return new IntIterator(){

                public boolean hasNext() {
                    boolean b = baseIter.hasNext();
                    System.err.println("IntIterator " + iterNr + " hasNext() = " + b);
                    return b;
                }

                public int next() {
                    int n = baseIter.next();
                    System.err.println("IntIterator " + iterNr + " next() = " + n);
                    return n;
                }
            };
        }

        public int getMatchLength() {
            return this.base.getMatchLength();
        }

        public boolean matchesEmptyString() {
            return this.base.matchesEmptyString();
        }

        public Operation optimize(REProgram program, REFlags flags) {
            this.base = this.base.optimize(program, flags);
            return this;
        }

        public String display() {
            return this.base.display();
        }
    }

    public static class OpNothing
    extends Operation {
        public IntIterator iterateMatches(REMatcher matcher, int position) {
            return new IntSingletonIterator(position);
        }

        public boolean matchesEmptyString() {
            return true;
        }

        public int getMatchLength() {
            return 0;
        }

        public String display() {
            return "()";
        }
    }

    public static class OpBackReference
    extends Operation {
        public int groupNr;

        public OpBackReference(int groupNr) {
            this.groupNr = groupNr;
        }

        public boolean matchesEmptyString() {
            return false;
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            int s = matcher.startBackref[this.groupNr];
            int e = matcher.endBackref[this.groupNr];
            if (s == -1 || e == -1) {
                return EmptyIntIterator.getInstance();
            }
            if (s == e) {
                return new IntSingletonIterator(position);
            }
            UnicodeString search = matcher.search;
            int l = e - s;
            if (search.isEnd(position + l - 1)) {
                return EmptyIntIterator.getInstance();
            }
            if (matcher.program.flags.isCaseIndependent()) {
                for (int i = 0; i < l; ++i) {
                    if (matcher.equalCaseBlind(search.uCharAt(position + i), search.uCharAt(s + i))) continue;
                    return EmptyIntIterator.getInstance();
                }
            } else {
                for (int i = 0; i < l; ++i) {
                    if (search.uCharAt(position + i) == search.uCharAt(s + i)) continue;
                    return EmptyIntIterator.getInstance();
                }
            }
            return new IntSingletonIterator(position + l);
        }

        public String display() {
            return "\\" + this.groupNr;
        }
    }

    public static class OpCapture
    extends Operation {
        public int groupNr;
        public Operation childOp;

        public OpCapture(Operation childOp, int group) {
            this.childOp = childOp;
            this.groupNr = group;
        }

        public int getMatchLength() {
            return this.childOp.getMatchLength();
        }

        public boolean matchesEmptyString() {
            return this.childOp.matchesEmptyString();
        }

        public Operation optimize(REProgram program, REFlags flags) {
            this.childOp = this.childOp.optimize(program, flags);
            return this;
        }

        public IntIterator iterateMatches(final REMatcher matcher, final int position) {
            if ((matcher.program.optimizationFlags & 1) != 0) {
                matcher.startBackref[this.groupNr] = position;
            }
            final IntIterator base = this.childOp.iterateMatches(matcher, position);
            return new IntIterator(){

                public boolean hasNext() {
                    return base.hasNext();
                }

                public int next() {
                    int next = base.next();
                    if (OpCapture.this.groupNr >= matcher.captureState.parenCount) {
                        matcher.captureState.parenCount = OpCapture.this.groupNr + 1;
                    }
                    matcher.setParenStart(OpCapture.this.groupNr, position);
                    matcher.setParenEnd(OpCapture.this.groupNr, next);
                    if ((matcher.program.optimizationFlags & 1) != 0) {
                        matcher.startBackref[OpCapture.this.groupNr] = position;
                        matcher.endBackref[OpCapture.this.groupNr] = next;
                    }
                    return next;
                }
            };
        }

        public String display() {
            return "(" + this.childOp.display() + ")";
        }
    }

    public static class OpEOL
    extends Operation {
        public int getMatchLength() {
            return 0;
        }

        public boolean matchesEmptyString() {
            return true;
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            UnicodeString search = matcher.search;
            if (matcher.program.flags.isMultiLine()) {
                if (search.isEnd(0) || search.isEnd(position) || matcher.isNewline(position)) {
                    return new IntSingletonIterator(position);
                }
                return EmptyIntIterator.getInstance();
            }
            if (search.isEnd(0) || search.isEnd(position)) {
                return new IntSingletonIterator(position);
            }
            return EmptyIntIterator.getInstance();
        }

        public String display() {
            return "$";
        }
    }

    public static class OpBOL
    extends Operation {
        public int getMatchLength() {
            return 0;
        }

        public boolean matchesEmptyString() {
            return true;
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            if (position != 0) {
                if (matcher.program.flags.isMultiLine() && matcher.isNewline(position - 1) && !matcher.search.isEnd(position)) {
                    return new IntSingletonIterator(position);
                }
                return EmptyIntIterator.getInstance();
            }
            return new IntSingletonIterator(position);
        }

        public String display() {
            return "^";
        }
    }

    public static class OpEndProgram
    extends Operation {
        public int getMatchLength() {
            return 0;
        }

        public boolean matchesEmptyString() {
            return true;
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            if (matcher.anchoredMatch) {
                if (matcher.search.isEnd(position)) {
                    return new IntSingletonIterator(position);
                }
                return EmptyIntIterator.getInstance();
            }
            matcher.setParenEnd(0, position);
            return new IntSingletonIterator(position);
        }

        public String display() {
            return "\\Z";
        }
    }

    public static class OpReluctantFixed
    extends OpRepeat {
        private int len;

        public OpReluctantFixed(Operation op, int min, int max, int len) {
            super(op, min, max, false);
            this.len = len;
        }

        public int getMatchLength() {
            return this.min == this.max ? this.min * this.len : -1;
        }

        public boolean matchesEmptyString() {
            return this.op.matchesEmptyString() || this.min == 0;
        }

        public Operation optimize(REProgram program, REFlags flags) {
            this.op = this.op.optimize(program, flags);
            return this;
        }

        public IntIterator iterateMatches(final REMatcher matcher, final int position) {
            return new IntIterator(){
                private int pos;
                private int count;
                private boolean started;
                {
                    this.pos = position;
                    this.count = 0;
                    this.started = false;
                }

                public boolean hasNext() {
                    if (!this.started) {
                        this.started = true;
                        while (this.count < OpReluctantFixed.this.min) {
                            IntIterator child = OpReluctantFixed.this.op.iterateMatches(matcher, this.pos);
                            if (child.hasNext()) {
                                this.pos = child.next();
                                ++this.count;
                                continue;
                            }
                            return false;
                        }
                        return true;
                    }
                    if (this.count < OpReluctantFixed.this.max) {
                        matcher.clearCapturedGroupsBeyond(this.pos);
                        IntIterator child = OpReluctantFixed.this.op.iterateMatches(matcher, this.pos);
                        if (child.hasNext()) {
                            this.pos = child.next();
                            ++this.count;
                            return true;
                        }
                    }
                    return false;
                }

                public int next() {
                    return this.pos;
                }
            };
        }
    }

    public static class OpRepeat
    extends Operation {
        protected Operation op;
        protected int min;
        protected int max;
        protected boolean greedy;

        public OpRepeat(Operation op, int min, int max, boolean greedy) {
            this.op = op;
            this.min = min;
            this.max = max;
            this.greedy = greedy;
        }

        public Operation getRepeatedOperation() {
            return this.op;
        }

        public boolean matchesEmptyString() {
            return this.min == 0 || this.op.matchesEmptyString();
        }

        public boolean containsCapturingExpressions() {
            return this.op instanceof OpCapture || this.op.containsCapturingExpressions();
        }

        public CharacterClass getInitialCharacterClass(boolean caseBlind) {
            return this.op.getInitialCharacterClass(caseBlind);
        }

        public int getMatchLength() {
            return this.min == this.max && this.op.getMatchLength() >= 0 ? this.min * this.op.getMatchLength() : -1;
        }

        public int getMinimumMatchLength() {
            return this.min * this.op.getMinimumMatchLength();
        }

        public Operation optimize(REProgram program, REFlags flags) {
            this.op = this.op.optimize(program, flags);
            if (this.min == 0 && this.op.matchesEmptyString()) {
                this.min = 1;
            }
            return this;
        }

        public IntIterator iterateMatches(final REMatcher matcher, final int position) {
            final Stack<IntIterator> iterators = new Stack<IntIterator>();
            final Stack<Integer> positions = new Stack<Integer>();
            final int bound = Math.min(this.max, matcher.search.uLength() - position + 1);
            int p = position;
            if (this.greedy) {
                if (this.min == 0 && !matcher.history.isDuplicateZeroLengthMatch(this, position)) {
                    iterators.push(new IntSingletonIterator(position));
                    positions.push(p);
                }
                for (int i = 0; i < bound; ++i) {
                    IntIterator it = this.op.iterateMatches(matcher, p);
                    if (!it.hasNext()) {
                        if (!iterators.isEmpty()) break;
                        return EmptyIntIterator.getInstance();
                    }
                    p = it.next();
                    iterators.push(it);
                    positions.push(p);
                }
                IntIterator base = new IntIterator(){
                    boolean primed = true;

                    private void advance() {
                        IntIterator top = (IntIterator)iterators.peek();
                        if (top.hasNext()) {
                            IntIterator it;
                            int p = top.next();
                            positions.pop();
                            positions.push(p);
                            while (iterators.size() < bound && (it = OpRepeat.this.op.iterateMatches(matcher, p)).hasNext()) {
                                p = it.next();
                                iterators.push(it);
                                positions.push(p);
                            }
                        } else {
                            iterators.pop();
                            positions.pop();
                        }
                    }

                    public boolean hasNext() {
                        if (this.primed && iterators.size() >= OpRepeat.this.min) {
                            return !iterators.isEmpty();
                        }
                        if (iterators.isEmpty()) {
                            return false;
                        }
                        do {
                            this.advance();
                        } while (iterators.size() < OpRepeat.this.min && !iterators.isEmpty());
                        return !iterators.isEmpty();
                    }

                    public int next() {
                        this.primed = false;
                        return (Integer)positions.peek();
                    }
                };
                return new ForceProgressIterator(base);
            }
            IntIterator iter = new IntIterator(){
                private int pos;
                private int counter;
                {
                    this.pos = position;
                    this.counter = 0;
                }

                private void advance() {
                    IntIterator it = OpRepeat.this.op.iterateMatches(matcher, this.pos);
                    if (it.hasNext()) {
                        this.pos = it.next();
                        if (++this.counter > OpRepeat.this.max) {
                            this.pos = -1;
                        }
                    } else if (OpRepeat.this.min == 0 && this.counter == 0) {
                        ++this.counter;
                    } else {
                        this.pos = -1;
                    }
                }

                public boolean hasNext() {
                    do {
                        this.advance();
                    } while (this.counter < OpRepeat.this.min && this.pos >= 0);
                    return this.pos >= 0;
                }

                public int next() {
                    return this.pos;
                }
            };
            return new ForceProgressIterator(iter);
        }

        public String display() {
            String quantifier = this.min == 0 && this.max == Integer.MAX_VALUE ? "*" : (this.min == 1 && this.max == Integer.MAX_VALUE ? "+" : (this.min == 0 && this.max == 1 ? "?" : "{" + this.min + "," + this.max + "}"));
            if (!this.greedy) {
                quantifier = quantifier + "?";
            }
            return this.op.display() + quantifier;
        }
    }

    public static class OpUnambiguousRepeat
    extends OpRepeat {
        public OpUnambiguousRepeat(Operation op, int min, int max) {
            super(op, min, max, true);
        }

        public boolean matchesEmptyString() {
            return this.op.matchesEmptyString() || this.min == 0;
        }

        public int getMatchLength() {
            if (this.op.getMatchLength() != -1 && this.min == this.max) {
                return this.op.getMatchLength() * this.min;
            }
            return -1;
        }

        public Operation optimize(REProgram program, REFlags flags) {
            this.op = this.op.optimize(program, flags);
            return this;
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            IntIterator it;
            int matches;
            int guard = matcher.search.uLength();
            int p = position;
            for (matches = 0; matches < this.max && p <= guard && (it = this.op.iterateMatches(matcher, p)).hasNext(); ++matches) {
                p = it.next();
            }
            if (matches < this.min) {
                return EmptyIntIterator.getInstance();
            }
            return new IntSingletonIterator(p);
        }
    }

    public static class OpGreedyFixed
    extends OpRepeat {
        private int len;

        public OpGreedyFixed(Operation op, int min, int max, int len) {
            super(op, min, max, true);
            this.len = len;
        }

        public int getMatchLength() {
            return this.min == this.max ? this.min * this.len : -1;
        }

        public boolean matchesEmptyString() {
            return this.op.matchesEmptyString() || this.min == 0;
        }

        public Operation optimize(REProgram program, REFlags flags) {
            if (this.max == 0) {
                return new OpNothing();
            }
            if (this.op.getMatchLength() == 0) {
                return this.op;
            }
            this.op = this.op.optimize(program, flags);
            return this;
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            int p;
            int guard = matcher.search.uLength();
            if (this.max < Integer.MAX_VALUE) {
                guard = Math.min(guard, position + this.len * this.max);
            }
            if (position >= guard && this.min > 0) {
                return EmptyIntIterator.getInstance();
            }
            int matches = 0;
            for (p = position; p <= guard; p += this.len) {
                IntIterator it = this.op.iterateMatches(matcher, p);
                boolean matched = false;
                if (it.hasNext()) {
                    matched = true;
                    it.next();
                }
                if (!matched) break;
                if (++matches != this.max) continue;
                break;
            }
            if (matches < this.min) {
                return EmptyIntIterator.getInstance();
            }
            return new IntStepIterator(p, -this.len, position + this.len * this.min);
        }
    }

    public static class OpAtom
    extends Operation {
        private UnicodeString atom;
        private int len;

        public OpAtom(UnicodeString atom) {
            this.atom = atom;
            this.len = atom.uLength();
        }

        public UnicodeString getAtom() {
            return this.atom;
        }

        public int getMatchLength() {
            return this.len;
        }

        public boolean matchesEmptyString() {
            return this.len == 0;
        }

        public CharacterClass getInitialCharacterClass(boolean caseBlind) {
            int ch;
            int[] variants;
            if (this.len == 0) {
                return EmptyCharacterClass.getInstance();
            }
            if (caseBlind && (variants = CaseVariants.getCaseVariants(ch = this.atom.uCharAt(0))).length > 0) {
                IntHashSet set = new IntHashSet(variants.length);
                set.add(ch);
                for (int v : variants) {
                    set.add(v);
                }
                return new IntSetCharacterClass(set);
            }
            return new SingletonCharacterClass(this.atom.uCharAt(0));
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            UnicodeString in = matcher.search;
            if (position + this.len > in.uLength()) {
                return EmptyIntIterator.getInstance();
            }
            if (matcher.program.flags.isCaseIndependent()) {
                for (int i = 0; i < this.len; ++i) {
                    if (matcher.equalCaseBlind(in.uCharAt(position + i), this.atom.uCharAt(i))) continue;
                    return EmptyIntIterator.getInstance();
                }
            } else {
                for (int i = 0; i < this.len; ++i) {
                    if (in.uCharAt(position + i) == this.atom.uCharAt(i)) continue;
                    return EmptyIntIterator.getInstance();
                }
            }
            return new IntSingletonIterator(position + this.len);
        }

        public String display() {
            return this.atom.toString();
        }
    }

    public static class OpCharClass
    extends Operation {
        private IntPredicate predicate;

        public OpCharClass(IntPredicate predicate) {
            this.predicate = predicate;
        }

        public IntPredicate getPredicate() {
            return this.predicate;
        }

        public int getMatchLength() {
            return 1;
        }

        public boolean matchesEmptyString() {
            return false;
        }

        public CharacterClass getInitialCharacterClass(boolean caseBlind) {
            if (this.predicate instanceof CharacterClass) {
                return (CharacterClass)this.predicate;
            }
            return super.getInitialCharacterClass(caseBlind);
        }

        public IntIterator iterateMatches(REMatcher matcher, int position) {
            UnicodeString in = matcher.search;
            if (position < in.uLength() && this.predicate.matches(in.uCharAt(position))) {
                return new IntSingletonIterator(position + 1);
            }
            return EmptyIntIterator.getInstance();
        }

        public String display() {
            if (this.predicate instanceof IntSetPredicate) {
                IntSet s = ((IntSetPredicate)this.predicate).getIntSet();
                if (s instanceof IntSingletonSet) {
                    return "" + (char)((IntSingletonSet)s).getMember();
                }
                if (s instanceof IntRangeSet) {
                    FastStringBuffer fsb = new FastStringBuffer(64);
                    IntRangeSet irs = (IntRangeSet)s;
                    fsb.append("[");
                    for (int i = 0; i < irs.getNumberOfRanges(); ++i) {
                        fsb.append((char)irs.getStartPoints()[1]);
                        fsb.append("-");
                        fsb.append((char)irs.getEndPoints()[1]);
                    }
                    fsb.append("[");
                    return fsb.toString();
                }
                return "[....]";
            }
            return "[....]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpSequence
    extends Operation {
        private List<Operation> operations;

        public OpSequence(List<Operation> operations) {
            this.operations = operations;
        }

        public List<Operation> getOperations() {
            return this.operations;
        }

        @Override
        public int getMatchLength() {
            int len = 0;
            for (Operation o : this.operations) {
                int i = o.getMatchLength();
                if (i == -1) {
                    return -1;
                }
                len += i;
            }
            return len;
        }

        @Override
        public int getMinimumMatchLength() {
            int len = 0;
            for (Operation o : this.operations) {
                len += o.getMinimumMatchLength();
            }
            return len;
        }

        @Override
        public boolean matchesEmptyString() {
            for (Operation o : this.operations) {
                if (o.matchesEmptyString()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsCapturingExpressions() {
            for (Operation o : this.operations) {
                if (!(o instanceof OpCapture) && !o.containsCapturingExpressions()) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharacterClass getInitialCharacterClass(boolean caseBlind) {
            CharacterClass result = EmptyCharacterClass.getInstance();
            for (Operation o : this.operations) {
                result = RECompiler.makeUnion(result, o.getInitialCharacterClass(caseBlind));
                if (o.matchesEmptyString()) continue;
                return result;
            }
            return result;
        }

        @Override
        public String display() {
            FastStringBuffer fsb = new FastStringBuffer(64);
            for (Operation op : this.operations) {
                fsb.append(op.display());
            }
            return fsb.toString();
        }

        @Override
        public Operation optimize(REProgram program, REFlags flags) {
            if (this.operations.isEmpty()) {
                return new OpNothing();
            }
            if (this.operations.size() == 1) {
                return this.operations.get(0);
            }
            for (int i = 0; i < this.operations.size() - 1; ++i) {
                Operation o1r;
                Operation o2;
                Operation o1 = this.operations.get(i);
                if (o1 != (o2 = o1.optimize(program, flags))) {
                    this.operations.set(i, o2);
                }
                if (!(o2 instanceof OpRepeat) || !((o1r = ((OpRepeat)o1).getRepeatedOperation()) instanceof OpAtom) && !(o1r instanceof OpCharClass)) continue;
                Operation o2r = this.operations.get(i + 1);
                if (((OpRepeat)o1).min != ((OpRepeat)o1).max && !RECompiler.noAmbiguity(o1r, o2r, flags.isCaseIndependent(), !((OpRepeat)o1).greedy)) continue;
                this.operations.set(i, new OpUnambiguousRepeat(o1r, ((OpRepeat)o1).min, ((OpRepeat)o1).max));
            }
            return this;
        }

        @Override
        public IntIterator iterateMatches(final REMatcher matcher, final int position) {
            final Stack iterators = new Stack();
            final REMatcher.State savedState = this.containsCapturingExpressions() ? matcher.captureState() : null;
            return new IntIterator(){
                private boolean primed = false;
                private int nextPos;

                private int advance() {
                    while (!iterators.isEmpty()) {
                        IntIterator top = (IntIterator)iterators.peek();
                        while (top.hasNext()) {
                            int p = top.next();
                            matcher.clearCapturedGroupsBeyond(p);
                            int i = iterators.size();
                            if (i >= OpSequence.this.operations.size()) {
                                return p;
                            }
                            top = ((Operation)OpSequence.this.operations.get(i)).iterateMatches(matcher, p);
                            iterators.push(top);
                        }
                        iterators.pop();
                    }
                    if (savedState != null) {
                        matcher.resetState(savedState);
                    }
                    return -1;
                }

                public boolean hasNext() {
                    if (!this.primed) {
                        iterators.push(((Operation)OpSequence.this.operations.get(0)).iterateMatches(matcher, position));
                        this.primed = true;
                    }
                    this.nextPos = this.advance();
                    return this.nextPos >= 0;
                }

                public int next() {
                    return this.nextPos;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpChoice
    extends Operation {
        List<Operation> branches;

        public OpChoice(List<Operation> branches) {
            this.branches = branches;
        }

        @Override
        public int getMatchLength() {
            int fixed = this.branches.get(0).getMatchLength();
            for (int i = 1; i < this.branches.size(); ++i) {
                if (this.branches.get(i).getMatchLength() == fixed) continue;
                return -1;
            }
            return fixed;
        }

        @Override
        public int getMinimumMatchLength() {
            int min = this.branches.get(0).getMinimumMatchLength();
            for (int i = 1; i < this.branches.size(); ++i) {
                int m = this.branches.get(i).getMinimumMatchLength();
                if (m >= min) continue;
                min = m;
            }
            return min;
        }

        @Override
        public boolean matchesEmptyString() {
            for (Operation branch : this.branches) {
                if (!branch.matchesEmptyString()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsCapturingExpressions() {
            for (Operation o : this.branches) {
                if (!(o instanceof OpCapture) && !o.containsCapturingExpressions()) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharacterClass getInitialCharacterClass(boolean caseBlind) {
            CharacterClass result = EmptyCharacterClass.getInstance();
            for (Operation o : this.branches) {
                result = RECompiler.makeUnion(result, o.getInitialCharacterClass(caseBlind));
            }
            return result;
        }

        @Override
        public Operation optimize(REProgram program, REFlags flags) {
            for (int i = 0; i < this.branches.size(); ++i) {
                Operation o2;
                Operation o1 = this.branches.get(i);
                if (o1 == (o2 = o1.optimize(program, flags))) continue;
                this.branches.set(i, o2);
            }
            return this;
        }

        @Override
        public IntIterator iterateMatches(final REMatcher matcher, final int position) {
            return new IntIterator(){
                Iterator<Operation> branchIter;
                IntIterator currentIter;
                Operation currentOp;
                {
                    this.branchIter = OpChoice.this.branches.iterator();
                    this.currentIter = null;
                    this.currentOp = null;
                }

                public boolean hasNext() {
                    while (true) {
                        if (this.currentIter == null) {
                            if (this.branchIter.hasNext()) {
                                matcher.clearCapturedGroupsBeyond(position);
                                this.currentOp = this.branchIter.next();
                                this.currentIter = this.currentOp.iterateMatches(matcher, position);
                            } else {
                                return false;
                            }
                        }
                        if (this.currentIter.hasNext()) {
                            return true;
                        }
                        this.currentIter = null;
                    }
                }

                public int next() {
                    return this.currentIter.next();
                }
            };
        }

        @Override
        public String display() {
            FastStringBuffer fsb = new FastStringBuffer(64);
            fsb.append("(?:");
            boolean first = true;
            for (Operation branch : this.branches) {
                if (first) {
                    first = false;
                } else {
                    fsb.append('|');
                }
                fsb.append(branch.display());
            }
            fsb.append(")");
            return fsb.toString();
        }
    }
}

