/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.InsertBefore;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.MapUntypedContains;
import net.sf.saxon.ma.map.TupleItemType;
import net.sf.saxon.om.Chain;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class MapFunctionSet
extends BuiltInFunctionSet {
    public static MapFunctionSet THE_INSTANCE = new MapFunctionSet();

    public MapFunctionSet() {
        this.init();
    }

    public static MapFunctionSet getInstance() {
        return THE_INSTANCE;
    }

    private void init() {
        this.register("merge", 1, MapMerge.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x100E000, null);
        OptionsParameter mergeOptionDetails = new OptionsParameter();
        mergeOptionDetails.addAllowedOption("duplicates", SequenceType.SINGLE_STRING, new StringValue("use-first"));
        mergeOptionDetails.setAllowedValues("duplicates", "FOJS0005", "use-first", "use-last", "combine", "reject", "unspecified", "use-any");
        mergeOptionDetails.addAllowedOption("duplicates-error-code", SequenceType.SINGLE_STRING, new StringValue("FOJS0003"));
        this.register("merge", 2, MapMerge.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 57344, null).arg(1, MapType.ANY_MAP_TYPE, 57344, null).optionDetails(mergeOptionDetails);
        this.register("entry", 2, MapEntry.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null).arg(1, AnyItemType.getInstance(), 0x800E000, null);
        this.register("find", 2, MapFind.class, ArrayItemType.getInstance(), 16384, 0, 0).arg(0, AnyItemType.getInstance(), 0x100E000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null);
        this.register("get", 2, MapGet.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null);
        this.register("put", 3, MapPut.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null).arg(2, AnyItemType.getInstance(), 0x800E000, null);
        this.register("contains", 2, MapContains.class, BuiltInAtomicType.BOOLEAN, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null);
        this.register("remove", 2, MapRemove.class, MapType.ANY_MAP_TYPE, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x200E000, null);
        this.register("keys", 1, MapKeys.class, BuiltInAtomicType.ANY_ATOMIC, 57344, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null);
        this.register("size", 1, MapSize.class, BuiltInAtomicType.INTEGER, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null);
        SpecificFunctionType actionType = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_ATOMIC, SequenceType.ANY_SEQUENCE}, SequenceType.ANY_SEQUENCE);
        this.register("for-each", 2, MapForEach.class, AnyItemType.getInstance(), 57344, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, actionType, 0x1004000, null);
        this.register("untyped-contains", 2, MapUntypedContains.class, BuiltInAtomicType.BOOLEAN, 16384, 0, 0).arg(0, MapType.ANY_MAP_TYPE, 0x1004000, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 0x2004000, null);
    }

    public String getNamespace() {
        return "http://www.w3.org/2005/xpath-functions/map";
    }

    public String getConventionalPrefix() {
        return "map";
    }

    public static class MapSize
    extends SystemFunction {
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem map = (MapItem)arguments[0].head();
            return new Int64Value(map.size());
        }
    }

    public static class MapRemove
    extends SystemFunction {
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            AtomicValue key;
            MapItem map = (MapItem)arguments[0].head();
            SequenceIterator iter = arguments[1].iterate();
            while ((key = (AtomicValue)iter.next()) != null) {
                map = map.remove(key);
            }
            return map;
        }
    }

    public static class MapPut
    extends SystemFunction {
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem baseMap = (MapItem)arguments[0].head();
            if (!(baseMap instanceof HashTrieMap)) {
                baseMap = HashTrieMap.copy(baseMap);
            }
            AtomicValue key = (AtomicValue)arguments[1].head();
            Sequence value = SequenceTool.makeRepeatable(arguments[2]);
            KeyValuePair pair = new KeyValuePair(key, value);
            return ((HashTrieMap)baseMap).addEntry(pair.key, pair.value);
        }
    }

    public static class MapMerge
    extends SystemFunction {
        private String duplicates = "use-first";
        private String duplicatesErrorCode = "FOJS0003";

        public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
            if (arguments.length == 2 && arguments[1] instanceof Literal) {
                MapItem options = (MapItem)((Literal)arguments[1]).getValue().head();
                Map<String, Sequence> values = this.getDetails().optionDetails.processSuppliedOptions(options, visitor.getStaticContext().makeEarlyEvaluationContext());
                String duplicates = ((StringValue)values.get("duplicates")).getStringValue();
                String duplicatesErrorCode = ((StringValue)values.get("duplicates-error-code")).getStringValue();
                MapMerge mm2 = (MapMerge)MapFunctionSet.getInstance().makeFunction("merge", 1);
                mm2.duplicates = duplicates;
                mm2.duplicatesErrorCode = duplicatesErrorCode;
                return mm2.makeFunctionCall(arguments[0]);
            }
            return super.makeOptimizedFunctionCall(visitor, contextInfo, arguments);
        }

        public ItemType getResultItemType(Expression[] args) {
            ItemType it = args[0].getItemType();
            return it == ErrorType.getInstance() ? MapType.EMPTY_MAP_TYPE : it;
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem next;
            SequenceIterator iter;
            MapItem baseMap;
            String duplicates = this.duplicates;
            String duplicatesErrorCode = this.duplicatesErrorCode;
            if (arguments.length > 1) {
                MapItem options = (MapItem)arguments[1].head();
                Map<String, Sequence> values = this.getDetails().optionDetails.processSuppliedOptions(options, context);
                duplicates = ((StringValue)values.get("duplicates")).getStringValue();
                duplicatesErrorCode = ((StringValue)values.get("duplicates-error-code")).getStringValue();
            }
            if ((baseMap = (MapItem)(iter = arguments[0].iterate()).next()) == null) {
                return new HashTrieMap();
            }
            if (!(baseMap instanceof HashTrieMap)) {
                baseMap = HashTrieMap.copy(baseMap);
            }
            while ((next = (MapItem)iter.next()) != null) {
                for (KeyValuePair pair : next) {
                    Sequence existing = baseMap.get(pair.key);
                    if (existing != null) {
                        if (duplicates.equals("use-first") || duplicates.equals("unspecified") || duplicates.equals("use-any")) continue;
                        if (duplicates.equals("use-last")) {
                            baseMap = ((HashTrieMap)baseMap).addEntry(pair.key, pair.value);
                            continue;
                        }
                        if (duplicates.equals("combine")) {
                            InsertBefore.InsertIterator combinedIter = new InsertBefore.InsertIterator(pair.value.iterate(), existing.iterate(), 1);
                            GroundedValue combinedValue = SequenceExtent.makeSequenceExtent(combinedIter);
                            baseMap = ((HashTrieMap)baseMap).addEntry(pair.key, combinedValue);
                            continue;
                        }
                        throw new XPathException("Duplicate key in constructed map: " + Err.wrap(pair.key.getStringValueCS()), duplicatesErrorCode);
                    }
                    baseMap = ((HashTrieMap)baseMap).addEntry(pair.key, pair.value);
                }
            }
            return baseMap;
        }

        public String getStreamerName() {
            return "NewMap";
        }

        public void exportAdditionalArguments(SystemFunctionCall call, ExpressionPresenter out) throws XPathException {
            if (call.getArity() == 1) {
                HashTrieMap options = new HashTrieMap();
                options.initialPut(new StringValue("duplicates"), new StringValue(this.duplicates));
                options.initialPut(new StringValue("duplicates-error-code"), new StringValue(this.duplicatesErrorCode));
                Literal.exportValue(options, out);
            }
        }
    }

    public static class MapKeys
    extends SystemFunction {
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem map = (MapItem)arguments[0].head();
            assert (map != null);
            return SequenceTool.toLazySequence(map.keys());
        }
    }

    public static class MapForEach
    extends SystemFunction {
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem map = (MapItem)arguments[0].head();
            Function fn = (Function)arguments[1].head();
            ArrayList<GroundedValue> results = new ArrayList<GroundedValue>();
            for (KeyValuePair pair : map) {
                Sequence seq = fn.call(context, new Sequence[]{pair.key, pair.value});
                results.add(SequenceTool.toGroundedValue(seq));
            }
            return new Chain(results);
        }
    }

    public static class MapEntry
    extends SystemFunction {
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            AtomicValue key = (AtomicValue)arguments[0].head();
            assert (key != null);
            GroundedValue value = SequenceExtent.makeSequenceExtent(arguments[1].iterate());
            return HashTrieMap.singleton(key, value, context);
        }

        public ItemType getResultItemType(Expression[] args) {
            PlainType ku = args[0].getItemType().getAtomizedItemType();
            AtomicType ka = ku instanceof AtomicType ? (AtomicType)ku : ku.getPrimitiveItemType();
            return new MapType(ka, SequenceType.makeSequenceType(args[1].getItemType(), args[1].getCardinality()));
        }

        public String getStreamerName() {
            return "MapEntry";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapFind
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayList<Sequence> result = new ArrayList<Sequence>();
            AtomicValue key = (AtomicValue)arguments[1].head();
            this.processSequence(arguments[0], key, result);
            return new SimpleArrayItem(result);
        }

        private void processSequence(Sequence in, AtomicValue key, List<Sequence> result) throws XPathException {
            Item item;
            SequenceIterator iter = in.iterate();
            while ((item = iter.next()) != null) {
                if (item instanceof ArrayItem) {
                    for (Sequence sequence : (ArrayItem)item) {
                        this.processSequence(sequence, key, result);
                    }
                    continue;
                }
                if (!(item instanceof MapItem)) continue;
                Sequence value = ((MapItem)item).get(key);
                if (value != null) {
                    result.add(value);
                }
                for (KeyValuePair entry : (MapItem)item) {
                    this.processSequence(entry.value, key, result);
                }
            }
        }
    }

    public static class MapGet
    extends SystemFunction {
        String pendingWarning = null;

        public ItemType getResultItemType(Expression[] args) {
            ItemType mapType = args[0].getItemType();
            if (mapType instanceof TupleItemType && args[1] instanceof StringLiteral) {
                TupleItemType tit = (TupleItemType)mapType;
                String key = ((StringLiteral)args[1]).getStringValue();
                SequenceType valueType = tit.getFieldType(key);
                if (valueType == null) {
                    this.warning("Field " + key + " is not defined in tuple type");
                    return AnyItemType.getInstance();
                }
                return valueType.getPrimaryType();
            }
            if (mapType instanceof MapType) {
                return ((MapType)mapType).getValueType().getPrimaryType();
            }
            return super.getResultItemType(args);
        }

        public int getCardinality(Expression[] args) {
            ItemType mapType = args[0].getItemType();
            if (mapType instanceof TupleItemType && args[1] instanceof StringLiteral) {
                TupleItemType tit = (TupleItemType)mapType;
                String key = ((StringLiteral)args[1]).getStringValue();
                SequenceType valueType = tit.getFieldType(key);
                if (valueType == null) {
                    this.warning("Field " + key + " is not defined in tuple type");
                    return 32768;
                }
                return valueType.getCardinality();
            }
            if (mapType instanceof MapType) {
                return Cardinality.union(((MapType)mapType).getValueType().getCardinality(), 8192);
            }
            return super.getCardinality(args);
        }

        public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
            if (this.pendingWarning != null && !this.pendingWarning.equals("DONE")) {
                visitor.issueWarning(this.pendingWarning, arguments[0].getLocation());
                this.pendingWarning = "DONE";
            }
            return null;
        }

        private void warning(String message) {
            if (!"DONE".equals(this.pendingWarning)) {
                this.pendingWarning = message;
            }
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem map = (MapItem)arguments[0].head();
            assert (map != null);
            AtomicValue key = (AtomicValue)arguments[1].head();
            Sequence value = map.get(key);
            if (value == null) {
                return EmptySequence.getInstance();
            }
            return value;
        }
    }

    public static class MapContains
    extends SystemFunction {
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            AtomicValue key;
            MapItem map = (MapItem)arguments[0].head();
            return BooleanValue.get(map.get(key = (AtomicValue)arguments[1].head()) != null);
        }
    }
}

