/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.time;

import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Objects;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.util.CsvContext;

public class FmtZoneId
extends CellProcessorAdaptor {
    private final TextStyle textStyle;
    private final Locale locale;

    public FmtZoneId() {
        this.textStyle = null;
        this.locale = null;
    }

    public FmtZoneId(CellProcessor next) {
        super(next);
        this.textStyle = null;
        this.locale = null;
    }

    public FmtZoneId(TextStyle textStyle, Locale locale) {
        Objects.requireNonNull(textStyle);
        Objects.requireNonNull(locale);
        this.textStyle = textStyle;
        this.locale = locale;
    }

    public FmtZoneId(TextStyle textStyle, Locale locale, CellProcessor next) {
        super(next);
        Objects.requireNonNull(textStyle);
        Objects.requireNonNull(locale);
        this.textStyle = textStyle;
        this.locale = locale;
    }

    public Object execute(Object value, CsvContext context) {
        this.validateInputNotNull(value, context);
        if (!(value instanceof ZoneId)) {
            throw new SuperCsvCellProcessorException(ZoneId.class, value, context, (CellProcessor)this);
        }
        ZoneId zoneId = (ZoneId)value;
        String result = this.textStyle != null && this.locale != null ? zoneId.getDisplayName(this.textStyle, this.locale) : zoneId.toString();
        return this.next.execute((Object)result, context);
    }
}

