/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.commons.configuration2.builder.combined;

import java.util.Arrays;
import java.util.Collection;
import net.snowflake.ingest.internal.apache.commons.configuration2.CombinedConfiguration;
import net.snowflake.ingest.internal.apache.commons.configuration2.Configuration;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.BasicBuilderParameters;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.BuilderParameters;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.combined.BaseConfigurationBuilderProvider;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.combined.ConfigurationDeclaration;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.combined.ReloadingCombinedConfigurationBuilder;

public class CombinedConfigurationBuilderProvider
extends BaseConfigurationBuilderProvider {
    private static final String BUILDER_CLASS = "net.snowflake.ingest.internal.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder";
    private static final String RELOADING_BUILDER_CLASS = "net.snowflake.ingest.internal.apache.commons.configuration2.builder.combined.ReloadingCombinedConfigurationBuilder";
    private static final String CONFIGURATION_CLASS = "net.snowflake.ingest.internal.apache.commons.configuration2.CombinedConfiguration";
    private static final String COMBINED_PARAMS = "net.snowflake.ingest.internal.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl";
    private static final String FILE_PARAMS = "net.snowflake.ingest.internal.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl";

    public CombinedConfigurationBuilderProvider() {
        super(BUILDER_CLASS, RELOADING_BUILDER_CLASS, CONFIGURATION_CLASS, Arrays.asList(COMBINED_PARAMS, FILE_PARAMS));
    }

    @Override
    protected BasicConfigurationBuilder<? extends Configuration> createBuilder(ConfigurationDeclaration decl, Collection<BuilderParameters> params) throws Exception {
        CombinedConfigurationBuilder builder = decl.isReload() ? new ReloadingCombinedConfigurationBuilder() : new CombinedConfigurationBuilder();
        decl.getConfigurationBuilder().initChildEventListeners(builder);
        return builder;
    }

    @Override
    protected void initializeParameterObjects(ConfigurationDeclaration decl, Collection<BuilderParameters> params) throws Exception {
        BasicBuilderParameters basicParams = (BasicBuilderParameters)params.iterator().next();
        CombinedConfigurationBuilderProvider.setUpBasicParameters(decl.getConfigurationBuilder().getConfigurationUnderConstruction(), basicParams);
        super.initializeParameterObjects(decl, params);
    }

    private static void setUpBasicParameters(CombinedConfiguration config, BasicBuilderParameters params) {
        params.setListDelimiterHandler(config.getListDelimiterHandler()).setLogger(config.getLogger()).setThrowExceptionOnMissing(config.isThrowExceptionOnMissing()).setConfigurationDecoder(config.getConfigurationDecoder());
    }
}

