/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.commons.configuration2.spring;

import java.net.URL;
import java.util.Properties;
import net.snowflake.ingest.internal.apache.commons.configuration2.CompositeConfiguration;
import net.snowflake.ingest.internal.apache.commons.configuration2.Configuration;
import net.snowflake.ingest.internal.apache.commons.configuration2.ConfigurationConverter;
import net.snowflake.ingest.internal.apache.commons.configuration2.PropertiesConfiguration;
import net.snowflake.ingest.internal.apache.commons.configuration2.builder.fluent.Configurations;
import net.snowflake.ingest.internal.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ConfigurationPropertiesFactoryBean
implements InitializingBean,
FactoryBean<Properties> {
    private CompositeConfiguration compositeConfiguration;
    private Configuration[] configurations;
    private Resource[] locations;
    private boolean throwExceptionOnMissing = true;

    public ConfigurationPropertiesFactoryBean() {
    }

    public ConfigurationPropertiesFactoryBean(Configuration configuration) {
        Assert.notNull((Object)configuration, (String)"configuration");
        this.compositeConfiguration = new CompositeConfiguration(configuration);
    }

    public Properties getObject() throws Exception {
        return this.compositeConfiguration != null ? ConfigurationConverter.getProperties(this.compositeConfiguration) : null;
    }

    public Class<?> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.compositeConfiguration == null && ArrayUtils.isEmpty((Object[])this.configurations) && ArrayUtils.isEmpty((Object[])this.locations)) {
            throw new IllegalArgumentException("no configuration object or location specified");
        }
        if (this.compositeConfiguration == null) {
            this.compositeConfiguration = new CompositeConfiguration();
        }
        this.compositeConfiguration.setThrowExceptionOnMissing(this.throwExceptionOnMissing);
        if (this.configurations != null) {
            for (Configuration configuration : this.configurations) {
                this.compositeConfiguration.addConfiguration(configuration);
            }
        }
        if (this.locations != null) {
            for (Configuration configuration : this.locations) {
                URL url = configuration.getURL();
                PropertiesConfiguration props = new Configurations().properties(url);
                this.compositeConfiguration.addConfiguration(props);
            }
        }
    }

    public Configuration[] getConfigurations() {
        return ConfigurationPropertiesFactoryBean.defensiveCopy(this.configurations);
    }

    public void setConfigurations(Configuration ... configurations) {
        this.configurations = ConfigurationPropertiesFactoryBean.defensiveCopy(configurations);
    }

    public Resource[] getLocations() {
        return ConfigurationPropertiesFactoryBean.defensiveCopy(this.locations);
    }

    public void setLocations(Resource ... locations) {
        this.locations = ConfigurationPropertiesFactoryBean.defensiveCopy(locations);
    }

    public boolean isThrowExceptionOnMissing() {
        return this.throwExceptionOnMissing;
    }

    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        this.throwExceptionOnMissing = throwExceptionOnMissing;
    }

    public CompositeConfiguration getConfiguration() {
        return this.compositeConfiguration;
    }

    private static <T> T[] defensiveCopy(T[] src) {
        return src != null ? (Object[])src.clone() : null;
    }
}

