/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.commons.net.tftp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import net.snowflake.ingest.internal.apache.commons.net.tftp.TFTPAckPacket;
import net.snowflake.ingest.internal.apache.commons.net.tftp.TFTPDataPacket;
import net.snowflake.ingest.internal.apache.commons.net.tftp.TFTPErrorPacket;
import net.snowflake.ingest.internal.apache.commons.net.tftp.TFTPPacketException;
import net.snowflake.ingest.internal.apache.commons.net.tftp.TFTPReadRequestPacket;
import net.snowflake.ingest.internal.apache.commons.net.tftp.TFTPWriteRequestPacket;

public abstract class TFTPPacket {
    static final int MIN_PACKET_SIZE = 4;
    public static final int READ_REQUEST = 1;
    public static final int WRITE_REQUEST = 2;
    public static final int DATA = 3;
    public static final int ACKNOWLEDGEMENT = 4;
    public static final int ERROR = 5;
    public static final int SEGMENT_SIZE = 512;
    int type;
    int port;
    InetAddress address;

    public static final TFTPPacket newTFTPPacket(DatagramPacket datagram) throws TFTPPacketException {
        TFTPPacket packet = null;
        if (datagram.getLength() < 4) {
            throw new TFTPPacketException("Bad packet. Datagram data length is too short.");
        }
        byte[] data = datagram.getData();
        switch (data[1]) {
            case 1: {
                packet = new TFTPReadRequestPacket(datagram);
                break;
            }
            case 2: {
                packet = new TFTPWriteRequestPacket(datagram);
                break;
            }
            case 3: {
                packet = new TFTPDataPacket(datagram);
                break;
            }
            case 4: {
                packet = new TFTPAckPacket(datagram);
                break;
            }
            case 5: {
                packet = new TFTPErrorPacket(datagram);
                break;
            }
            default: {
                throw new TFTPPacketException("Bad packet.  Invalid TFTP operator code.");
            }
        }
        return packet;
    }

    TFTPPacket(int type, InetAddress address, int port) {
        this.type = type;
        this.address = address;
        this.port = port;
    }

    public final InetAddress getAddress() {
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    public final int getType() {
        return this.type;
    }

    public abstract DatagramPacket newDatagram();

    abstract DatagramPacket newDatagram(DatagramPacket var1, byte[] var2);

    public final void setAddress(InetAddress address) {
        this.address = address;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return this.address + " " + this.port + " " + this.type;
    }
}

