/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.crypto.CryptoCodec;
import net.snowflake.ingest.internal.apache.hadoop.crypto.CryptoStreamUtils;
import net.snowflake.ingest.internal.apache.hadoop.crypto.Encryptor;
import net.snowflake.ingest.internal.apache.hadoop.fs.CanSetDropBehind;
import net.snowflake.ingest.internal.apache.hadoop.fs.StreamCapabilities;
import net.snowflake.ingest.internal.apache.hadoop.fs.Syncable;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.StoreImplementationUtils;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatistics;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsSource;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsSupport;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CryptoOutputStream
extends FilterOutputStream
implements Syncable,
CanSetDropBehind,
StreamCapabilities,
IOStatisticsSource {
    private final byte[] oneByteBuf = new byte[1];
    private final CryptoCodec codec;
    private final Encryptor encryptor;
    private final int bufferSize;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;
    private long streamOffset = 0L;
    private byte padding;
    private boolean closed;
    private final byte[] key;
    private final byte[] initIV;
    private byte[] iv;
    private boolean closeOutputStream;
    private byte[] tmpBuf;

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, int bufferSize, byte[] key, byte[] iv) throws IOException {
        this(out, codec, bufferSize, key, iv, 0L);
    }

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, int bufferSize, byte[] key, byte[] iv, long streamOffset) throws IOException {
        this(out, codec, bufferSize, key, iv, streamOffset, true);
    }

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, int bufferSize, byte[] key, byte[] iv, long streamOffset, boolean closeOutputStream) throws IOException {
        super(out);
        CryptoStreamUtils.checkCodec(codec);
        this.bufferSize = CryptoStreamUtils.checkBufferSize(codec, bufferSize);
        this.codec = codec;
        this.key = (byte[])key.clone();
        this.initIV = (byte[])iv.clone();
        this.iv = (byte[])iv.clone();
        this.inBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        this.outBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        this.streamOffset = streamOffset;
        this.closeOutputStream = closeOutputStream;
        try {
            this.encryptor = codec.createEncryptor();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        this.updateEncryptor();
    }

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, byte[] key, byte[] iv) throws IOException {
        this(out, codec, key, iv, 0L);
    }

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, byte[] key, byte[] iv, long streamOffset) throws IOException {
        this(out, codec, key, iv, streamOffset, true);
    }

    public CryptoOutputStream(OutputStream out, CryptoCodec codec, byte[] key, byte[] iv, long streamOffset, boolean closeOutputStream) throws IOException {
        this(out, codec, CryptoStreamUtils.getBufferSize(codec.getConf()), key, iv, streamOffset, closeOutputStream);
    }

    public OutputStream getWrappedStream() {
        return this.out;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int remaining = this.inBuffer.remaining();
            if (len < remaining) {
                this.inBuffer.put(b, off, len);
                len = 0;
                continue;
            }
            this.inBuffer.put(b, off, remaining);
            off += remaining;
            len -= remaining;
            this.encrypt();
        }
    }

    private void encrypt() throws IOException {
        Preconditions.checkState(this.inBuffer.position() >= this.padding);
        if (this.inBuffer.position() == this.padding) {
            return;
        }
        this.inBuffer.flip();
        this.outBuffer.clear();
        this.encryptor.encrypt(this.inBuffer, this.outBuffer);
        this.inBuffer.clear();
        this.outBuffer.flip();
        if (this.padding > 0) {
            this.outBuffer.position(this.padding);
            this.padding = 0;
        }
        int len = this.outBuffer.remaining();
        byte[] tmp = this.getTmpBuf();
        this.outBuffer.get(tmp, 0, len);
        this.out.write(tmp, 0, len);
        this.streamOffset += (long)len;
        if (this.encryptor.isContextReset()) {
            this.updateEncryptor();
        }
    }

    private void updateEncryptor() throws IOException {
        long counter = this.streamOffset / (long)this.codec.getCipherSuite().getAlgorithmBlockSize();
        this.padding = (byte)(this.streamOffset % (long)this.codec.getCipherSuite().getAlgorithmBlockSize());
        this.inBuffer.position(this.padding);
        this.codec.calculateIV(this.initIV, counter, this.iv);
        this.encryptor.init(this.key, this.iv);
    }

    private byte[] getTmpBuf() {
        if (this.tmpBuf == null) {
            this.tmpBuf = new byte[this.bufferSize];
        }
        return this.tmpBuf;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            try {
                this.flush();
            }
            finally {
                if (this.closeOutputStream) {
                    super.close();
                    this.codec.close();
                }
                this.freeBuffers();
            }
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            return;
        }
        this.encrypt();
        super.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByteBuf[0] = (byte)(b & 0xFF);
        this.write(this.oneByteBuf, 0, this.oneByteBuf.length);
    }

    private void checkStream() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void setDropBehind(Boolean dropCache) throws IOException, UnsupportedOperationException {
        try {
            ((CanSetDropBehind)((Object)this.out)).setDropBehind(dropCache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("This stream does not support setting the drop-behind caching.");
        }
    }

    @Override
    public void hflush() throws IOException {
        this.flush();
        if (this.out instanceof Syncable) {
            ((Syncable)((Object)this.out)).hflush();
        }
    }

    @Override
    public void hsync() throws IOException {
        this.flush();
        if (this.out instanceof Syncable) {
            ((Syncable)((Object)this.out)).hsync();
        }
    }

    private void freeBuffers() {
        CryptoStreamUtils.freeDB(this.inBuffer);
        CryptoStreamUtils.freeDB(this.outBuffer);
    }

    @Override
    public boolean hasCapability(String capability) {
        return StoreImplementationUtils.hasCapability(this.out, capability);
    }

    @Override
    public IOStatistics getIOStatistics() {
        return IOStatisticsSupport.retrieveIOStatistics(this.out);
    }
}

