/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.NoSuchElementException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.AbstractFileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.ChecksumException;
import net.snowflake.ingest.internal.apache.hadoop.fs.CreateFlag;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataInputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSInputChecker;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSOutputSummer;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileAlreadyExistsException;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.FilterFs;
import net.snowflake.ingest.internal.apache.hadoop.fs.LocatedFileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.Options;
import net.snowflake.ingest.internal.apache.hadoop.fs.ParentNotDirectoryException;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.RemoteIterator;
import net.snowflake.ingest.internal.apache.hadoop.fs.UnresolvedLinkException;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsPermission;
import net.snowflake.ingest.internal.apache.hadoop.security.AccessControlException;
import net.snowflake.ingest.internal.apache.hadoop.util.DataChecksum;
import net.snowflake.ingest.internal.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class ChecksumFs
extends FilterFs {
    private static final byte[] CHECKSUM_VERSION = new byte[]{99, 114, 99, 0};
    private int defaultBytesPerChecksum = this.getMyFs().getServerDefaults(new Path("/")).getBytesPerChecksum();
    private boolean verifyChecksum = true;

    public static double getApproxChkSumLength(long size) {
        return 0.01f * (float)size;
    }

    public ChecksumFs(AbstractFileSystem theFs) throws IOException, URISyntaxException {
        super(theFs);
    }

    @Override
    public void setVerifyChecksum(boolean inVerifyChecksum) {
        this.verifyChecksum = inVerifyChecksum;
    }

    public AbstractFileSystem getRawFs() {
        return this.getMyFs();
    }

    public Path getChecksumFile(Path file) {
        return new Path(file.getParent(), "." + file.getName() + ".crc");
    }

    public static boolean isChecksumFile(Path file) {
        String name = file.getName();
        return name.startsWith(".") && name.endsWith(".crc");
    }

    public long getChecksumFileLength(Path file, long fileSize) {
        return ChecksumFs.getChecksumLength(fileSize, this.getBytesPerSum());
    }

    public int getBytesPerSum() {
        return this.defaultBytesPerChecksum;
    }

    private int getSumBufferSize(int bytesPerSum, int bufferSize, Path file) throws IOException {
        int defaultBufferSize = this.getMyFs().getServerDefaults(file).getFileBufferSize();
        int proportionalBufferSize = bufferSize / bytesPerSum;
        return Math.max(bytesPerSum, Math.max(proportionalBufferSize, defaultBufferSize));
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        throw new UnsupportedOperationException("Truncate is not supported by ChecksumFs");
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException, UnresolvedLinkException {
        return new FSDataInputStream(new ChecksumFSInputChecker(this, f, bufferSize));
    }

    public static long getChecksumLength(long size, int bytesPerSum) {
        return (size + (long)bytesPerSum - 1L) / (long)bytesPerSum * 4L + (long)CHECKSUM_VERSION.length + 4L;
    }

    @Override
    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> createFlag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
        FSDataOutputStream out = new FSDataOutputStream(new ChecksumFSOutputSummer(this, f, createFlag, absolutePermission, bufferSize, replication, blockSize, progress, checksumOpt, createParent), null);
        return out;
    }

    private boolean exists(Path f) throws IOException, UnresolvedLinkException {
        try {
            return this.getMyFs().getFileStatus(f) != null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    private boolean isDirectory(Path f) throws IOException, UnresolvedLinkException {
        try {
            return this.getMyFs().getFileStatus(f).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean setReplication(Path src, short replication) throws IOException, UnresolvedLinkException {
        boolean value = this.getMyFs().setReplication(src, replication);
        if (!value) {
            return false;
        }
        Path checkFile = this.getChecksumFile(src);
        if (this.exists(checkFile)) {
            this.getMyFs().setReplication(checkFile, replication);
        }
        return true;
    }

    @Override
    public void renameInternal(Path src, Path dst) throws IOException, UnresolvedLinkException {
        if (this.isDirectory(src)) {
            this.getMyFs().rename(src, dst, new Options.Rename[0]);
        } else {
            this.getMyFs().rename(src, dst, new Options.Rename[0]);
            Path checkFile = this.getChecksumFile(src);
            if (this.exists(checkFile)) {
                if (this.isDirectory(dst)) {
                    this.getMyFs().rename(checkFile, dst, new Options.Rename[0]);
                } else {
                    this.getMyFs().rename(checkFile, this.getChecksumFile(dst), new Options.Rename[0]);
                }
            }
        }
    }

    @Override
    public void renameInternal(Path src, Path dst, boolean overwrite) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException, IOException {
        Options.Rename renameOpt = Options.Rename.NONE;
        if (overwrite) {
            renameOpt = Options.Rename.OVERWRITE;
        }
        if (this.isDirectory(src)) {
            this.getMyFs().rename(src, dst, renameOpt);
        } else {
            this.getMyFs().rename(src, dst, renameOpt);
            Path checkFile = this.getChecksumFile(src);
            if (this.exists(checkFile)) {
                if (this.isDirectory(dst)) {
                    this.getMyFs().rename(checkFile, dst, renameOpt);
                } else {
                    this.getMyFs().rename(checkFile, this.getChecksumFile(dst), renameOpt);
                }
            }
        }
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException, UnresolvedLinkException {
        FileStatus fstatus = null;
        try {
            fstatus = this.getMyFs().getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (fstatus.isDirectory()) {
            return this.getMyFs().delete(f, recursive);
        }
        Path checkFile = this.getChecksumFile(f);
        if (this.exists(checkFile)) {
            this.getMyFs().delete(checkFile, true);
        }
        return this.getMyFs().delete(f, true);
    }

    public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        return false;
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException, UnresolvedLinkException {
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        FileStatus[] listing = this.getMyFs().listStatus(f);
        if (listing != null) {
            for (int i = 0; i < listing.length; ++i) {
                if (ChecksumFs.isChecksumFile(listing[i].getPath())) continue;
                results.add(listing[i]);
            }
        }
        return results.toArray(new FileStatus[results.size()]);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        final RemoteIterator<LocatedFileStatus> iter = this.getMyFs().listLocatedStatus(f);
        return new RemoteIterator<LocatedFileStatus>(){
            private LocatedFileStatus next = null;

            @Override
            public boolean hasNext() throws IOException {
                while (this.next == null && iter.hasNext()) {
                    LocatedFileStatus unfilteredNext = (LocatedFileStatus)iter.next();
                    if (ChecksumFs.isChecksumFile(unfilteredNext.getPath())) continue;
                    this.next = unfilteredNext;
                }
                return this.next != null;
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                LocatedFileStatus tmp = this.next;
                this.next = null;
                return tmp;
            }
        };
    }

    private static class ChecksumFSOutputSummer
    extends FSOutputSummer {
        private FSDataOutputStream datas;
        private FSDataOutputStream sums;
        private static final float CHKSUM_AS_FRACTION = 0.01f;
        private boolean isClosed = false;

        public ChecksumFSOutputSummer(ChecksumFs fs, Path file, EnumSet<CreateFlag> createFlag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
            super(DataChecksum.newDataChecksum(DataChecksum.Type.CRC32, fs.getBytesPerSum()));
            this.datas = fs.getRawFs().createInternal(file, createFlag, absolutePermission, bufferSize, replication, blockSize, progress, checksumOpt, createParent);
            int bytesPerSum = fs.getBytesPerSum();
            int sumBufferSize = fs.getSumBufferSize(bytesPerSum, bufferSize, file);
            this.sums = fs.getRawFs().createInternal(fs.getChecksumFile(file), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), absolutePermission, sumBufferSize, replication, blockSize, progress, checksumOpt, createParent);
            this.sums.write(CHECKSUM_VERSION, 0, CHECKSUM_VERSION.length);
            this.sums.writeInt(bytesPerSum);
        }

        @Override
        public void close() throws IOException {
            try {
                this.flushBuffer();
                this.sums.close();
                this.datas.close();
            }
            finally {
                this.isClosed = true;
            }
        }

        @Override
        protected void writeChunk(byte[] b, int offset, int len, byte[] checksum, int ckoff, int cklen) throws IOException {
            this.datas.write(b, offset, len);
            this.sums.write(checksum, ckoff, cklen);
        }

        @Override
        protected void checkClosed() throws IOException {
            if (this.isClosed) {
                throw new ClosedChannelException();
            }
        }
    }

    private static class ChecksumFSInputChecker
    extends FSInputChecker {
        public static final Logger LOG = LoggerFactory.getLogger(FSInputChecker.class);
        private static final int HEADER_LENGTH = 8;
        private ChecksumFs fs;
        private FSDataInputStream datas;
        private FSDataInputStream sums;
        private int bytesPerSum = 1;
        private long fileLen = -1L;

        public ChecksumFSInputChecker(ChecksumFs fs, Path file) throws IOException, UnresolvedLinkException {
            this(fs, file, fs.getServerDefaults(file).getFileBufferSize());
        }

        public ChecksumFSInputChecker(ChecksumFs fs, Path file, int bufferSize) throws IOException, UnresolvedLinkException {
            super(file, fs.getFileStatus(file).getReplication());
            this.datas = fs.getRawFs().open(file, bufferSize);
            this.fs = fs;
            Path sumFile = fs.getChecksumFile(file);
            try {
                int sumBufferSize = fs.getSumBufferSize(fs.getBytesPerSum(), bufferSize, file);
                this.sums = fs.getRawFs().open(sumFile, sumBufferSize);
                byte[] version = new byte[CHECKSUM_VERSION.length];
                this.sums.readFully(version);
                if (!Arrays.equals(version, CHECKSUM_VERSION)) {
                    throw new IOException("Not a checksum file: " + sumFile);
                }
                this.bytesPerSum = this.sums.readInt();
                this.set(fs.verifyChecksum, DataChecksum.newCrc32(), this.bytesPerSum, 4);
            }
            catch (FileNotFoundException e) {
                this.set(fs.verifyChecksum, null, 1, 0);
            }
            catch (IOException e) {
                LOG.warn("Problem opening checksum file: " + file + ".  Ignoring exception: ", (Throwable)e);
                this.set(fs.verifyChecksum, null, 1, 0);
            }
        }

        private long getChecksumFilePos(long dataPos) {
            return 8L + 4L * (dataPos / (long)this.bytesPerSum);
        }

        @Override
        protected long getChunkPosition(long dataPos) {
            return dataPos / (long)this.bytesPerSum * (long)this.bytesPerSum;
        }

        @Override
        public int available() throws IOException {
            return this.datas.available() + super.available();
        }

        @Override
        public int read(long position, byte[] b, int off, int len) throws IOException, UnresolvedLinkException {
            int nread;
            this.validatePositionedReadArgs(position, b, off, len);
            if (len == 0) {
                return 0;
            }
            try (ChecksumFSInputChecker checker = new ChecksumFSInputChecker(this.fs, this.file);){
                checker.seek(position);
                nread = checker.read(b, off, len);
            }
            return nread;
        }

        @Override
        public void close() throws IOException {
            this.datas.close();
            if (this.sums != null) {
                this.sums.close();
            }
            this.set(this.fs.verifyChecksum, null, 1, 0);
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            long sumsPos = this.getChecksumFilePos(targetPos);
            this.fs.reportChecksumFailure(this.file, this.datas, targetPos, this.sums, sumsPos);
            boolean newDataSource = this.datas.seekToNewSource(targetPos);
            return this.sums.seekToNewSource(sumsPos) || newDataSource;
        }

        @Override
        protected int readChunk(long pos, byte[] buf, int offset, int len, byte[] checksum) throws IOException {
            boolean eof = false;
            if (this.needChecksum()) {
                int sumLenRead;
                assert (checksum != null);
                assert (checksum.length % 4 == 0);
                assert (len >= this.bytesPerSum);
                int checksumsToRead = Math.min(len / this.bytesPerSum, checksum.length / 4);
                long checksumPos = this.getChecksumFilePos(pos);
                if (checksumPos != this.sums.getPos()) {
                    this.sums.seek(checksumPos);
                }
                if ((sumLenRead = this.sums.read(checksum, 0, 4 * checksumsToRead)) >= 0 && sumLenRead % 4 != 0) {
                    throw new EOFException("Checksum file not a length multiple of checksum size in " + this.file + " at " + pos + " checksumpos: " + checksumPos + " sumLenread: " + sumLenRead);
                }
                if (sumLenRead <= 0) {
                    eof = true;
                } else {
                    len = Math.min(len, this.bytesPerSum * (sumLenRead / 4));
                }
            }
            if (pos != this.datas.getPos()) {
                this.datas.seek(pos);
            }
            int nread = ChecksumFSInputChecker.readFully(this.datas, buf, offset, len);
            if (eof && nread > 0) {
                throw new ChecksumException("Checksum error: " + this.file + " at " + pos, pos);
            }
            return nread;
        }

        private long getFileLength() throws IOException, UnresolvedLinkException {
            if (this.fileLen == -1L) {
                this.fileLen = this.fs.getFileStatus(this.file).getLen();
            }
            return this.fileLen;
        }

        @Override
        public synchronized long skip(long n) throws IOException {
            long fileLength;
            long curPos = this.getPos();
            if (n + curPos > (fileLength = this.getFileLength())) {
                n = fileLength - curPos;
            }
            return super.skip(n);
        }

        @Override
        public synchronized void seek(long pos) throws IOException {
            if (pos > this.getFileLength()) {
                throw new IOException("Cannot seek after EOF");
            }
            super.seek(pos);
        }
    }
}

