/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs;

import java.io.IOException;
import java.util.Set;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.BlockLocation;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LocatedFileStatus
extends FileStatus {
    private static final long serialVersionUID = 389257504L;
    private BlockLocation[] locations;

    public LocatedFileStatus() {
    }

    public LocatedFileStatus(FileStatus stat, BlockLocation[] locations) {
        this(stat.getLen(), stat.isDirectory(), stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), null, stat.getPath(), stat.hasAcl(), stat.isEncrypted(), stat.isErasureCoded(), locations);
        if (stat.isSymlink()) {
            try {
                this.setSymlink(stat.getSymlink());
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }
    }

    @Deprecated
    public LocatedFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path symlink, Path path, BlockLocation[] locations) {
        this(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path, permission == null ? false : permission.getAclBit(), permission == null ? false : permission.getEncryptedBit(), permission == null ? false : permission.getErasureCodedBit(), locations);
    }

    public LocatedFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path symlink, Path path, boolean hasAcl, boolean isEncrypted, boolean isErasureCoded, BlockLocation[] locations) {
        this(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path, LocatedFileStatus.attributes(hasAcl, isEncrypted, isErasureCoded, false), locations);
        this.locations = locations;
    }

    public LocatedFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path symlink, Path path, Set<FileStatus.AttrFlags> attr, BlockLocation[] locations) {
        super(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path, attr);
        this.locations = locations;
    }

    public BlockLocation[] getBlockLocations() {
        return this.locations;
    }

    protected void setBlockLocations(BlockLocation[] locations) {
        this.locations = locations;
    }

    @Override
    public int compareTo(FileStatus o) {
        return super.compareTo(o);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

