/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs;

import java.io.IOException;
import java.util.List;
import net.snowflake.ingest.internal.apache.commons.lang3.builder.ToStringBuilder;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RemoteException;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class PartialListing<T extends FileStatus> {
    private final Path listedPath;
    private final List<T> partialListing;
    private final RemoteException exception;

    public PartialListing(Path listedPath, List<T> partialListing) {
        this(listedPath, partialListing, null);
    }

    public PartialListing(Path listedPath, RemoteException exception) {
        this(listedPath, null, exception);
    }

    private PartialListing(Path listedPath, List<T> partialListing, RemoteException exception) {
        Preconditions.checkArgument(partialListing == null ^ exception == null);
        this.partialListing = partialListing;
        this.listedPath = listedPath;
        this.exception = exception;
    }

    public List<T> get() throws IOException {
        if (this.exception != null) {
            throw this.exception.unwrapRemoteException();
        }
        return this.partialListing;
    }

    public Path getListedPath() {
        return this.listedPath;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("listedPath", (Object)this.listedPath).append("partialListing", this.partialListing).append("exception", (Object)this.exception).toString();
    }
}

