/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntFunction;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.BufferedFSInputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.CreateFlag;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataInputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSDataOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSError;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSInputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.FSLinkResolver;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileAlreadyExistsException;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileRange;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileSystem;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileUtil;
import net.snowflake.ingest.internal.apache.hadoop.fs.FsStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.HasFileDescriptor;
import net.snowflake.ingest.internal.apache.hadoop.fs.LocalFileSystemPathHandle;
import net.snowflake.ingest.internal.apache.hadoop.fs.Options;
import net.snowflake.ingest.internal.apache.hadoop.fs.ParentNotDirectoryException;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathHandle;
import net.snowflake.ingest.internal.apache.hadoop.fs.Stat;
import net.snowflake.ingest.internal.apache.hadoop.fs.StreamCapabilities;
import net.snowflake.ingest.internal.apache.hadoop.fs.Syncable;
import net.snowflake.ingest.internal.apache.hadoop.fs.VectoredReadUtils;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import net.snowflake.ingest.internal.apache.hadoop.fs.impl.StoreImplementationUtils;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsPermission;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.BufferedIOStatisticsOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatistics;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsContext;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsSource;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import net.snowflake.ingest.internal.apache.hadoop.io.IOUtils;
import net.snowflake.ingest.internal.apache.hadoop.io.nativeio.NativeIO;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import net.snowflake.ingest.internal.apache.hadoop.util.Progressable;
import net.snowflake.ingest.internal.apache.hadoop.util.Shell;
import net.snowflake.ingest.internal.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RawLocalFileSystem
extends FileSystem {
    static final URI NAME = URI.create("file:///");
    private Path workingDir = this.getInitialWorkingDirectory();
    private long defaultBlockSize;
    private static boolean useDeprecatedFileStatus = true;

    @VisibleForTesting
    public static void useStatIfAvailable() {
        useDeprecatedFileStatus = !Stat.isAvailable();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    public File pathToFile(Path path) {
        this.checkPath(path);
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory(), path);
        }
        return new File(path.toUri().getPath());
    }

    @Override
    public URI getUri() {
        return NAME;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        this.defaultBlockSize = this.getDefaultBlockSize(new Path(uri));
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.getFileStatus(f);
        return new FSDataInputStream(new BufferedFSInputStream(new LocalFSFileInputStream(f), bufferSize));
    }

    @Override
    public FSDataInputStream open(PathHandle fd, int bufferSize) throws IOException {
        if (!(fd instanceof LocalFileSystemPathHandle)) {
            fd = new LocalFileSystemPathHandle(fd.bytes());
        }
        LocalFileSystemPathHandle id = (LocalFileSystemPathHandle)fd;
        id.verify(this.getFileStatus(new Path(id.getPath())));
        return new FSDataInputStream(new BufferedFSInputStream(new LocalFSFileInputStream(new Path(id.getPath())), bufferSize));
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        FileStatus status = this.getFileStatus(f);
        if (status.isDirectory()) {
            throw new IOException("Cannot append to a diretory (=" + f + " )");
        }
        return new FSDataOutputStream(new BufferedOutputStream(this.createOutputStreamWithMode(f, true, null), bufferSize), this.statistics, status.getLen());
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, overwrite, true, bufferSize, replication, blockSize, progress, null);
    }

    private FSDataOutputStream create(Path f, boolean overwrite, boolean createParent, int bufferSize, short replication, long blockSize, Progressable progress, FsPermission permission) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new FileAlreadyExistsException("File already exists: " + f);
        }
        Path parent = f.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent.toString());
        }
        return new FSDataOutputStream(new BufferedIOStatisticsOutputStream(this.createOutputStreamWithMode(f, false, permission), bufferSize, true), this.statistics);
    }

    protected OutputStream createOutputStream(Path f, boolean append) throws IOException {
        return this.createOutputStreamWithMode(f, append, null);
    }

    protected OutputStream createOutputStreamWithMode(Path f, boolean append, FsPermission permission) throws IOException {
        return new LocalFSFileOutputStream(f, append, permission);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(f) && !flags.contains((Object)CreateFlag.OVERWRITE)) {
            throw new FileAlreadyExistsException("File already exists: " + f);
        }
        return new FSDataOutputStream(new BufferedIOStatisticsOutputStream(this.createOutputStreamWithMode(f, false, permission), bufferSize, true), this.statistics);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.create(f, overwrite, true, bufferSize, replication, blockSize, progress, permission);
        return out;
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream out = this.create(f, overwrite, false, bufferSize, replication, blockSize, progress, permission);
        return out;
    }

    @Override
    public void concat(Path trg, Path[] psrcs) throws IOException {
        int bufferSize = 4096;
        try (FSDataOutputStream out = this.create(trg);){
            for (Path src : psrcs) {
                try (FSDataInputStream in = this.open(src);){
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, 4096, false);
                }
            }
        }
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        File dstFile;
        File srcFile = this.pathToFile(src);
        if (srcFile.renameTo(dstFile = this.pathToFile(dst))) {
            return true;
        }
        if (Shell.WINDOWS && this.handleEmptyDstDirectoryOnWindows(src, srcFile, dst, dstFile)) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Falling through to a copy of " + src + " to " + dst));
        }
        return FileUtil.copy(this, src, this, dst, true, this.getConf());
    }

    @VisibleForTesting
    public final boolean handleEmptyDstDirectoryOnWindows(Path src, File srcFile, Path dst, File dstFile) throws IOException {
        try {
            FileStatus sdst = this.getFileStatus(dst);
            String[] dstFileList = dstFile.list();
            if (dstFileList != null && sdst.isDirectory() && dstFileList.length == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Deleting empty destination and renaming " + src + " to " + dst));
                }
                if (this.delete(dst, false) && srcFile.renameTo(dstFile)) {
                    return true;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        FileStatus status = this.getFileStatus(f);
        if (status == null) {
            throw new FileNotFoundException("File " + f + " not found");
        }
        if (status.isDirectory()) {
            throw new IOException("Cannot truncate a directory (=" + f + ")");
        }
        long oldLength = status.getLen();
        if (newLength > oldLength) {
            throw new IllegalArgumentException("Cannot truncate to a larger file size. Current size: " + oldLength + ", truncate size: " + newLength + ".");
        }
        try (FileOutputStream out = new FileOutputStream(this.pathToFile(f), true);){
            try {
                out.getChannel().truncate(newLength);
            }
            catch (IOException e) {
                throw new FSError(e);
            }
        }
        return true;
    }

    @Override
    public boolean delete(Path p, boolean recursive) throws IOException {
        File f = this.pathToFile(p);
        if (!f.exists()) {
            return false;
        }
        if (f.isFile()) {
            return f.delete();
        }
        if (!recursive && f.isDirectory() && FileUtil.listFiles(f).length != 0) {
            throw new IOException("Directory " + f.toString() + " is not empty");
        }
        return FileUtil.fullyDelete(f);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        File localf = this.pathToFile(f);
        if (!localf.exists()) {
            throw new FileNotFoundException("File " + f + " does not exist");
        }
        if (localf.isDirectory()) {
            String[] names = FileUtil.list(localf);
            FileStatus[] results = new FileStatus[names.length];
            int j = 0;
            for (int i = 0; i < names.length; ++i) {
                try {
                    results[j] = this.getFileStatus(new Path(f, new Path(null, null, names[i])));
                    ++j;
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (j == names.length) {
                return results;
            }
            return Arrays.copyOf(results, j);
        }
        if (!useDeprecatedFileStatus) {
            return new FileStatus[]{this.getFileStatus(f)};
        }
        return new FileStatus[]{new DeprecatedRawLocalFileStatus(localf, this.defaultBlockSize, this)};
    }

    @Override
    public boolean exists(Path f) throws IOException {
        return this.pathToFile(f).exists();
    }

    protected boolean mkOneDir(File p2f) throws IOException {
        return this.mkOneDirWithMode(new Path(p2f.getAbsolutePath()), p2f, null);
    }

    protected boolean mkOneDirWithMode(Path p, File p2f, FsPermission permission) throws IOException {
        if (permission == null) {
            permission = FsPermission.getDirDefault();
        }
        permission = permission.applyUMask(FsPermission.getUMask(this.getConf()));
        if (Shell.WINDOWS && NativeIO.isAvailable()) {
            try {
                NativeIO.Windows.createDirectoryWithMode(p2f, permission.toShort());
                return true;
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("NativeIO.createDirectoryWithMode error, path = %s, mode = %o", p2f, permission.toShort()), (Throwable)e);
                }
                return false;
            }
        }
        boolean b = p2f.mkdir();
        if (b) {
            this.setPermission(p, permission);
        }
        return b;
    }

    @Override
    public boolean mkdirs(Path f) throws IOException {
        return this.mkdirsWithOptionalPermission(f, null);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mkdirsWithOptionalPermission(f, permission);
    }

    private boolean mkdirsWithOptionalPermission(Path f, FsPermission permission) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException("mkdirs path arg is null");
        }
        Path parent = f.getParent();
        File p2f = this.pathToFile(f);
        File parent2f = null;
        if (parent != null && (parent2f = this.pathToFile(parent)) != null && parent2f.exists() && !parent2f.isDirectory()) {
            throw new ParentNotDirectoryException("Parent path is not a directory: " + parent);
        }
        if (p2f.exists() && !p2f.isDirectory()) {
            throw new FileAlreadyExistsException("Destination exists and is not a directory: " + p2f.getCanonicalPath());
        }
        return !(parent != null && !parent2f.exists() && !this.mkdirs(parent) || !this.mkOneDirWithMode(f, p2f, permission) && !p2f.isDirectory());
    }

    @Override
    public Path getHomeDirectory() {
        return this.makeQualified(new Path(System.getProperty("user.home")));
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeAbsolute(newDir);
        this.checkPath(this.workingDir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    protected Path getInitialWorkingDirectory() {
        return this.makeQualified(new Path(System.getProperty("user.dir")));
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        File partition = this.pathToFile(p == null ? new Path("/") : p);
        return new FsStatus(partition.getTotalSpace(), partition.getTotalSpace() - partition.getFreeSpace(), partition.getFreeSpace());
    }

    @Override
    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.rename(src, dst);
    }

    @Override
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return fsOutputFile;
    }

    @Override
    public void completeLocalOutput(Path fsWorkingFile, Path tmpLocalFile) throws IOException {
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        return "LocalFS";
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.getFileLinkStatusInternal(f, true);
    }

    @Deprecated
    private FileStatus deprecatedGetFileStatus(Path f) throws IOException {
        File path = this.pathToFile(f);
        if (path.exists()) {
            return new DeprecatedRawLocalFileStatus(this.pathToFile(f), this.defaultBlockSize, this);
        }
        throw new FileNotFoundException("File " + f + " does not exist");
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        FileUtil.setOwner(this.pathToFile(p), username, groupname);
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        if (NativeIO.isAvailable()) {
            NativeIO.POSIX.chmod(this.pathToFile(p).getCanonicalPath(), permission.toShort());
        } else {
            String perm = String.format("%04o", permission.toShort());
            Shell.execCommand(Shell.getSetPermissionCommand(perm, false, FileUtil.makeShellPath(this.pathToFile(p), true)));
        }
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        try {
            BasicFileAttributeView view = Files.getFileAttributeView(this.pathToFile(p).toPath(), BasicFileAttributeView.class, new LinkOption[0]);
            FileTime fmtime = mtime >= 0L ? FileTime.fromMillis(mtime) : null;
            FileTime fatime = atime >= 0L ? FileTime.fromMillis(atime) : null;
            view.setTimes(fmtime, fatime, null);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException("File " + p + " does not exist");
        }
    }

    @Override
    protected PathHandle createPathHandle(FileStatus stat, Options.HandleOpt ... opts) {
        if (stat.isDirectory() || stat.isSymlink()) {
            throw new IllegalArgumentException("PathHandle only available for files");
        }
        String authority = stat.getPath().toUri().getAuthority();
        if (authority != null && !authority.equals("file://")) {
            throw new IllegalArgumentException("Wrong FileSystem: " + stat.getPath());
        }
        Options.HandleOpt.Data data = Options.HandleOpt.getOpt(Options.HandleOpt.Data.class, opts).orElse(Options.HandleOpt.changed(false));
        Options.HandleOpt.Location loc = Options.HandleOpt.getOpt(Options.HandleOpt.Location.class, opts).orElse(Options.HandleOpt.moved(false));
        if (loc.allowChange()) {
            throw new UnsupportedOperationException("Tracking file movement in basic FileSystem is not supported");
        }
        Path p = stat.getPath();
        Optional<Long> mtime = !data.allowChange() ? Optional.of(stat.getModificationTime()) : Optional.empty();
        return new LocalFileSystemPathHandle(p.toString(), mtime);
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        int result;
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        String targetScheme = target.toUri().getScheme();
        if (targetScheme != null && !"file".equals(targetScheme)) {
            throw new IOException("Unable to create symlink to non-local file system: " + target.toString());
        }
        if (createParent) {
            this.mkdirs(link.getParent());
        }
        if ((result = FileUtil.symLink(target.toString(), this.makeAbsolute(link).toString())) != 0) {
            throw new IOException("Error " + result + " creating symlink " + link + " to " + target);
        }
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException {
        FileStatus fi = this.getFileLinkStatusInternal(f, false);
        if (fi.isSymlink()) {
            Path targetQual = FSLinkResolver.qualifySymlinkTarget(this.getUri(), fi.getPath(), fi.getSymlink());
            fi.setSymlink(targetQual);
        }
        return fi;
    }

    private FileStatus getFileLinkStatusInternal(Path f, boolean dereference) throws IOException {
        if (!useDeprecatedFileStatus) {
            return this.getNativeFileLinkStatus(f, dereference);
        }
        if (dereference) {
            return this.deprecatedGetFileStatus(f);
        }
        return this.deprecatedGetFileLinkStatusInternal(f);
    }

    @Deprecated
    private FileStatus deprecatedGetFileLinkStatusInternal(Path f) throws IOException {
        String target = FileUtil.readLink(new File(f.toString()));
        try {
            FileStatus fs = this.getFileStatus(f);
            if (target.isEmpty()) {
                return fs;
            }
            return new FileStatus(fs.getLen(), false, fs.getReplication(), fs.getBlockSize(), fs.getModificationTime(), fs.getAccessTime(), fs.getPermission(), fs.getOwner(), fs.getGroup(), new Path(target), f);
        }
        catch (FileNotFoundException e) {
            if (!target.isEmpty()) {
                return new FileStatus(0L, false, 0, 0L, 0L, 0L, FsPermission.getDefault(), "", "", new Path(target), f);
            }
            throw e;
        }
    }

    private FileStatus getNativeFileLinkStatus(Path f, boolean dereference) throws IOException {
        this.checkPath(f);
        Stat stat = new Stat(f, this.defaultBlockSize, dereference, this);
        FileStatus status = stat.getFileStatus();
        return status;
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        FileStatus fi = this.getFileLinkStatusInternal(f, false);
        return fi.getSymlink();
    }

    @Override
    public boolean hasPathCapability(Path path, String capability) throws IOException {
        switch (PathCapabilitiesSupport.validatePathCapabilityArgs(this.makeQualified(path), capability)) {
            case "fs.capability.paths.append": 
            case "fs.capability.paths.concat": 
            case "fs.capability.paths.pathhandles": 
            case "fs.capability.paths.permissions": 
            case "fs.capability.paths.truncate": {
                return true;
            }
            case "fs.capability.paths.symlinks": {
                return FileSystem.areSymlinksEnabled();
            }
        }
        return super.hasPathCapability(path, capability);
    }

    @Deprecated
    static class DeprecatedRawLocalFileStatus
    extends FileStatus {
        private boolean isPermissionLoaded() {
            return !super.getOwner().isEmpty();
        }

        private static long getLastAccessTime(File f) throws IOException {
            long accessTime;
            try {
                accessTime = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime().toMillis();
            }
            catch (NoSuchFileException e) {
                throw new FileNotFoundException("File " + f + " does not exist");
            }
            return accessTime;
        }

        DeprecatedRawLocalFileStatus(File f, long defaultBlockSize, FileSystem fs) throws IOException {
            super(f.length(), f.isDirectory(), 1, defaultBlockSize, f.lastModified(), DeprecatedRawLocalFileStatus.getLastAccessTime(f), null, null, null, new Path(f.getPath()).makeQualified(fs.getUri(), fs.getWorkingDirectory()));
        }

        @Override
        public FsPermission getPermission() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getPermission();
        }

        @Override
        public String getOwner() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getOwner();
        }

        @Override
        public String getGroup() {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            return super.getGroup();
        }

        private synchronized void loadPermissionInfo() {
            if (!this.isPermissionLoaded() && NativeIO.isAvailable()) {
                try {
                    this.loadPermissionInfoByNativeIO();
                }
                catch (IOException ex) {
                    FileSystem.LOG.debug((Object)"Native call failed", (Throwable)ex);
                }
            }
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfoByNonNativeIO();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        void loadPermissionInfoByNonNativeIO() {
            block10: {
                IOException e = null;
                try {
                    String output = FileUtil.execCommand(new File(this.getPath().toUri()), Shell.getGetPermissionCommand());
                    StringTokenizer t2 = new StringTokenizer(output, Shell.TOKEN_SEPARATOR_REGEX);
                    String permission = t2.nextToken();
                    if (permission.length() > 10) {
                        permission = permission.substring(0, 10);
                    }
                    this.setPermission(FsPermission.valueOf(permission));
                    t2.nextToken();
                    String owner = t2.nextToken();
                    String group = t2.nextToken();
                    if (Shell.WINDOWS) {
                        owner = this.removeDomain(owner);
                        group = this.removeDomain(group);
                    }
                    this.setOwner(owner);
                    this.setGroup(group);
                }
                catch (Shell.ExitCodeException ioe) {
                    if (ioe.getExitCode() != 1) {
                        e = ioe;
                    }
                    this.setPermission(null);
                    this.setOwner(null);
                    this.setGroup(null);
                }
                catch (IOException ioe) {
                    e = ioe;
                }
                finally {
                    if (e == null) break block10;
                    throw new RuntimeException("Error while running command to get file permissions : " + StringUtils.stringifyException(e));
                }
            }
        }

        private String removeDomain(String str) {
            int index = str.indexOf("\\");
            if (index != -1) {
                str = str.substring(index + 1);
            }
            return str;
        }

        @VisibleForTesting
        void loadPermissionInfoByNativeIO() throws IOException {
            Path path = this.getPath();
            String pathName = path.toUri().getPath();
            if (Shell.WINDOWS && pathName.startsWith("/")) {
                pathName = pathName.substring(1);
            }
            try {
                NativeIO.POSIX.Stat stat = NativeIO.POSIX.getStat(pathName);
                String owner = stat.getOwner();
                String group = stat.getGroup();
                int mode = stat.getMode();
                this.setOwner(owner);
                this.setGroup(group);
                this.setPermission(new FsPermission(mode));
            }
            catch (IOException e) {
                this.setOwner(null);
                this.setGroup(null);
                this.setPermission(null);
                throw e;
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            if (!this.isPermissionLoaded()) {
                this.loadPermissionInfo();
            }
            super.write(out);
        }
    }

    final class LocalFSFileOutputStream
    extends OutputStream
    implements IOStatisticsSource,
    StreamCapabilities,
    Syncable {
        private FileOutputStream fos;
        private final IOStatisticsStore ioStatistics = IOStatisticsBinding.iostatisticsStore().withCounters("stream_write_bytes", "stream_write_exceptions").build();
        private final IOStatisticsAggregator ioStatisticsAggregator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private LocalFSFileOutputStream(Path f, boolean append, FsPermission permission) throws IOException {
            File file = RawLocalFileSystem.this.pathToFile(f);
            this.ioStatisticsAggregator = IOStatisticsContext.getCurrentIOStatisticsContext().getAggregator();
            if (!append && permission == null) {
                permission = FsPermission.getFileDefault();
            }
            if (permission == null) {
                this.fos = new FileOutputStream(file, append);
                return;
            } else {
                permission = permission.applyUMask(FsPermission.getUMask(RawLocalFileSystem.this.getConf()));
                if (Shell.WINDOWS && NativeIO.isAvailable()) {
                    this.fos = NativeIO.Windows.createFileOutputStreamWithMode(file, append, permission.toShort());
                    return;
                } else {
                    this.fos = new FileOutputStream(file, append);
                    boolean success = false;
                    try {
                        RawLocalFileSystem.this.setPermission(f, permission);
                        return;
                    }
                    catch (Throwable throwable) {
                        if (success) throw throwable;
                        IOUtils.cleanup(FileSystem.LOG, this.fos);
                        throw throwable;
                    }
                }
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.fos.close();
            }
            finally {
                this.ioStatisticsAggregator.aggregate(this.ioStatistics);
            }
        }

        @Override
        public void flush() throws IOException {
            this.fos.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.fos.write(b, off, len);
                this.ioStatistics.incrementCounter("stream_write_bytes", len);
            }
            catch (IOException e) {
                this.ioStatistics.incrementCounter("stream_write_exceptions");
                throw new FSError(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.fos.write(b);
                this.ioStatistics.incrementCounter("stream_write_bytes");
            }
            catch (IOException e) {
                this.ioStatistics.incrementCounter("stream_write_exceptions");
                throw new FSError(e);
            }
        }

        @Override
        public void hflush() throws IOException {
            this.flush();
        }

        @Override
        public void hsync() throws IOException {
            this.flush();
            this.fos.getFD().sync();
        }

        @Override
        public boolean hasCapability(String capability) {
            switch (capability.toLowerCase(Locale.ENGLISH)) {
                case "iostatistics": 
                case "fs.capability.iocontext.supported": {
                    return true;
                }
            }
            return StoreImplementationUtils.isProbeForSyncable(capability);
        }

        @Override
        public IOStatistics getIOStatistics() {
            return this.ioStatistics;
        }
    }

    static class AsyncHandler
    implements CompletionHandler<Integer, Integer> {
        private final AsynchronousFileChannel channel;
        private final List<? extends FileRange> ranges;
        private final ByteBuffer[] buffers;

        AsyncHandler(AsynchronousFileChannel channel, List<? extends FileRange> ranges, ByteBuffer[] buffers) {
            this.channel = channel;
            this.ranges = ranges;
            this.buffers = buffers;
        }

        @Override
        public void completed(Integer result, Integer r) {
            FileRange range = this.ranges.get(r);
            ByteBuffer buffer = this.buffers[r];
            if (result == -1) {
                this.failed((Throwable)new EOFException("Read past End of File"), r);
            } else if (buffer.remaining() > 0) {
                this.channel.read(buffer, range.getOffset() + (long)buffer.position(), r, this);
            } else {
                buffer.flip();
                range.getData().complete(buffer);
            }
        }

        @Override
        public void failed(Throwable exc, Integer r) {
            FileSystem.LOG.debug((Object)("Failed while reading range " + r + " {} "), exc);
            this.ranges.get(r).getData().completeExceptionally(exc);
        }
    }

    class LocalFSFileInputStream
    extends FSInputStream
    implements HasFileDescriptor,
    IOStatisticsSource,
    StreamCapabilities {
        private FileInputStream fis;
        private final File name;
        private long position;
        private AsynchronousFileChannel asyncChannel = null;
        private final IOStatisticsStore ioStatistics = IOStatisticsBinding.iostatisticsStore().withCounters("stream_read_bytes", "stream_read_exceptions", "stream_read_seek_operations", "stream_read_skip_operations", "stream_read_skip_bytes").build();
        private final AtomicLong bytesRead;
        private final IOStatisticsAggregator ioStatisticsAggregator;

        public LocalFSFileInputStream(Path f) throws IOException {
            this.name = RawLocalFileSystem.this.pathToFile(f);
            this.fis = new FileInputStream(this.name);
            this.bytesRead = this.ioStatistics.getCounterReference("stream_read_bytes");
            this.ioStatisticsAggregator = IOStatisticsContext.getCurrentIOStatisticsContext().getAggregator();
        }

        @Override
        public void seek(long pos) throws IOException {
            if (pos < 0L) {
                throw new EOFException("Cannot seek to a negative offset");
            }
            this.fis.getChannel().position(pos);
            this.position = pos;
        }

        @Override
        public long getPos() throws IOException {
            return this.position;
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        @Override
        public int available() throws IOException {
            return this.fis.available();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void close() throws IOException {
            try {
                this.fis.close();
                if (this.asyncChannel != null) {
                    this.asyncChannel.close();
                }
            }
            finally {
                this.ioStatisticsAggregator.aggregate(this.ioStatistics);
            }
        }

        @Override
        public int read() throws IOException {
            try {
                int value = this.fis.read();
                if (value >= 0) {
                    ++this.position;
                    RawLocalFileSystem.this.statistics.incrementBytesRead(1L);
                    this.bytesRead.addAndGet(1L);
                }
                return value;
            }
            catch (IOException e) {
                this.ioStatistics.incrementCounter("stream_read_exceptions");
                throw new FSError(e);
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.validatePositionedReadArgs(this.position, b, off, len);
            try {
                int value = this.fis.read(b, off, len);
                if (value > 0) {
                    this.position += (long)value;
                    RawLocalFileSystem.this.statistics.incrementBytesRead(value);
                    this.bytesRead.addAndGet(value);
                }
                return value;
            }
            catch (IOException e) {
                this.ioStatistics.incrementCounter("stream_read_exceptions");
                throw new FSError(e);
            }
        }

        @Override
        public int read(long position, byte[] b, int off, int len) throws IOException {
            this.validatePositionedReadArgs(position, b, off, len);
            if (len == 0) {
                return 0;
            }
            ByteBuffer bb = ByteBuffer.wrap(b, off, len);
            try {
                int value = this.fis.getChannel().read(bb, position);
                if (value > 0) {
                    RawLocalFileSystem.this.statistics.incrementBytesRead(value);
                    this.ioStatistics.incrementCounter("stream_read_bytes", value);
                }
                return value;
            }
            catch (IOException e) {
                this.ioStatistics.incrementCounter("stream_read_exceptions");
                throw new FSError(e);
            }
        }

        @Override
        public long skip(long n) throws IOException {
            this.ioStatistics.incrementCounter("stream_read_skip_operations");
            long value = this.fis.skip(n);
            if (value > 0L) {
                this.position += value;
                this.ioStatistics.incrementCounter("stream_read_skip_bytes", value);
            }
            return value;
        }

        @Override
        public FileDescriptor getFileDescriptor() throws IOException {
            return this.fis.getFD();
        }

        @Override
        public boolean hasCapability(String capability) {
            switch (capability.toLowerCase(Locale.ENGLISH)) {
                case "iostatistics": 
                case "fs.capability.iocontext.supported": 
                case "in:readvectored": {
                    return true;
                }
            }
            return false;
        }

        @Override
        public IOStatistics getIOStatistics() {
            return this.ioStatistics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AsynchronousFileChannel getAsyncChannel() throws IOException {
            if (this.asyncChannel == null) {
                LocalFSFileInputStream localFSFileInputStream = this;
                synchronized (localFSFileInputStream) {
                    this.asyncChannel = AsynchronousFileChannel.open(this.name.toPath(), StandardOpenOption.READ);
                }
            }
            return this.asyncChannel;
        }

        @Override
        public void readVectored(List<? extends FileRange> ranges, IntFunction<ByteBuffer> allocate) throws IOException {
            List<FileRange> sortedRanges = Arrays.asList(VectoredReadUtils.sortRanges(ranges));
            for (FileRange range : sortedRanges) {
                VectoredReadUtils.validateRangeRequest(range);
                range.setData(new CompletableFuture<ByteBuffer>());
            }
            try {
                AsynchronousFileChannel channel = this.getAsyncChannel();
                ByteBuffer[] buffers = new ByteBuffer[sortedRanges.size()];
                AsyncHandler asyncHandler = new AsyncHandler(channel, sortedRanges, buffers);
                for (int i = 0; i < sortedRanges.size(); ++i) {
                    FileRange range = sortedRanges.get(i);
                    buffers[i] = allocate.apply(range.getLength());
                    channel.read(buffers[i], range.getOffset(), i, asyncHandler);
                }
            }
            catch (IOException ioe) {
                FileSystem.LOG.debug((Object)"Exception occurred during vectored read ", (Throwable)ioe);
                for (FileRange range : sortedRanges) {
                    range.getData().completeExceptionally(ioe);
                }
            }
        }
    }
}

