/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathHandle;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class RawPathHandle
implements PathHandle {
    private static final long serialVersionUID = 1286953538832L;
    public static final int MAX_SIZE = 0x100000;
    private transient ByteBuffer fd;

    public RawPathHandle(ByteBuffer fd) {
        this.fd = null == fd ? ByteBuffer.allocate(0) : fd.asReadOnlyBuffer();
    }

    public RawPathHandle(PathHandle handle) {
        ByteBuffer hb = null == handle ? ByteBuffer.allocate(0) : handle.bytes();
        this.fd = ByteBuffer.allocate(hb.remaining());
        this.fd.put(hb);
        this.fd.flip();
    }

    @Override
    public ByteBuffer bytes() {
        return this.fd.asReadOnlyBuffer();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PathHandle)) {
            return false;
        }
        PathHandle o = (PathHandle)other;
        return this.bytes().equals(o.bytes());
    }

    public int hashCode() {
        return this.bytes().hashCode();
    }

    public String toString() {
        return this.bytes().toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.fd.remaining());
        if (this.fd.hasArray()) {
            out.write(this.fd.array(), this.fd.position(), this.fd.remaining());
        } else {
            byte[] x = new byte[this.fd.remaining()];
            this.fd.slice().get(x);
            out.write(x);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int len = in.readInt();
        if (len < 0 || len > 0x100000) {
            throw new IOException("Illegal buffer length " + len);
        }
        byte[] x = new byte[len];
        in.readFully(x);
        this.fd = ByteBuffer.wrap(x);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }
}

