/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.permission;

import java.util.regex.Pattern;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileStatus;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.FsPermission;
import net.snowflake.ingest.internal.apache.hadoop.fs.permission.PermissionParser;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ChmodParser
extends PermissionParser {
    private static Pattern chmodOctalPattern = Pattern.compile("^\\s*[+]?([01]?)([0-7]{3})\\s*$");
    private static Pattern chmodNormalPattern = Pattern.compile("\\G\\s*([ugoa]*)([+=-]+)([rwxXt]+)([,\\s]*)\\s*");

    public ChmodParser(String modeStr) throws IllegalArgumentException {
        super(modeStr, chmodNormalPattern, chmodOctalPattern);
    }

    public short applyNewPermission(FileStatus file) {
        FsPermission perms = file.getPermission();
        short existing = perms.toShort();
        boolean exeOk = file.isDirectory() || (existing & 0x49) != 0;
        return (short)this.combineModes(existing, exeOk);
    }
}

