/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathExistsException;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathIOException;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathIsNotDirectoryException;
import net.snowflake.ingest.internal.apache.hadoop.fs.PathNotFoundException;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CommandFactory;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.CommandFormat;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.FsCommand;
import net.snowflake.ingest.internal.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Mkdir
extends FsCommand {
    public static final String NAME = "mkdir";
    public static final String USAGE = "[-p] <path> ...";
    public static final String DESCRIPTION = "Create a directory in specified location.\n-p: Do not fail if the directory already exists";
    private boolean createParents;

    Mkdir() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Mkdir.class, "-mkdir");
    }

    @Override
    protected void processOptions(LinkedList<String> args) {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "p");
        cf.parse(args);
        this.createParents = cf.getOpt("p");
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        if (item.stat.isDirectory()) {
            if (!this.createParents) {
                throw new PathExistsException(item.toString());
            }
        } else {
            throw new PathIsNotDirectoryException(item.toString());
        }
    }

    @Override
    protected void processNonexistentPath(PathData item) throws IOException {
        if (!this.createParents) {
            Path itemPath = new Path(item.path.toString());
            Path itemParentPath = itemPath.getParent();
            if (itemParentPath == null) {
                throw new PathNotFoundException(String.format("Item: %s parent's path is null. This can happen if mkdir is called on root, so there's no parent.", itemPath.toString()));
            }
            if (!item.fs.exists(itemParentPath)) {
                throw new PathNotFoundException(itemParentPath.toString());
            }
        }
        if (!item.fs.mkdirs(item.path)) {
            throw new PathIOException(item.toString());
        }
    }
}

