/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.statistics.impl;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.DurationTrackerFactory;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatistics;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsSetters;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.MeanStatistic;

public interface IOStatisticsStore
extends IOStatistics,
IOStatisticsSetters,
IOStatisticsAggregator,
DurationTrackerFactory {
    default public long incrementCounter(String key) {
        return this.incrementCounter(key, 1L);
    }

    public long incrementCounter(String var1, long var2);

    public long incrementGauge(String var1, long var2);

    public long incrementMaximum(String var1, long var2);

    public long incrementMinimum(String var1, long var2);

    public void addMinimumSample(String var1, long var2);

    public void addMaximumSample(String var1, long var2);

    public void addMeanStatisticSample(String var1, long var2);

    public void reset();

    public AtomicLong getCounterReference(String var1);

    public AtomicLong getMaximumReference(String var1);

    public AtomicLong getMinimumReference(String var1);

    public AtomicLong getGaugeReference(String var1);

    public MeanStatistic getMeanStatistic(String var1);

    public void addTimedOperation(String var1, long var2);

    public void addTimedOperation(String var1, Duration var2);

    default public void addSample(String key, long count) {
        this.incrementCounter(key, count);
        this.addMeanStatisticSample(key, count);
        this.addMaximumSample(key, count);
        this.addMinimumSample(key, count);
    }
}

