/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.store;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.snowflake.ingest.internal.apache.hadoop.fs.FileChecksum;

public class EtagChecksum
extends FileChecksum {
    private static final String ETAG = "etag";
    private String eTag = "";

    public EtagChecksum() {
    }

    public EtagChecksum(String eTag) {
        this.eTag = eTag;
    }

    @Override
    public String getAlgorithmName() {
        return ETAG;
    }

    @Override
    public int getLength() {
        return this.eTag.getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    public byte[] getBytes() {
        return this.eTag != null ? this.eTag.getBytes(StandardCharsets.UTF_8) : new byte[]{};
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.eTag != null ? this.eTag : "");
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.eTag = in.readUTF();
    }

    public String toString() {
        return "etag: \"" + this.eTag + '\"';
    }
}

