/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.fs.store.audit;

import java.util.concurrent.Callable;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.store.audit.AuditSpan;
import net.snowflake.ingest.internal.apache.hadoop.util.functional.CallableRaisingIOE;
import net.snowflake.ingest.internal.apache.hadoop.util.functional.FunctionRaisingIOE;
import net.snowflake.ingest.internal.apache.hadoop.util.functional.InvocationRaisingIOE;
import net.snowflake.ingest.internal.javax.annotation.Nullable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class AuditingFunctions {
    private AuditingFunctions() {
    }

    public static <T> CallableRaisingIOE<T> withinAuditSpan(@Nullable AuditSpan auditSpan, CallableRaisingIOE<T> operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            return operation.apply();
        };
    }

    public static InvocationRaisingIOE withinAuditSpan(@Nullable AuditSpan auditSpan, InvocationRaisingIOE operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            operation.apply();
        };
    }

    public static <T, R> FunctionRaisingIOE<T, R> withinAuditSpan(@Nullable AuditSpan auditSpan, FunctionRaisingIOE<T, R> operation) {
        return auditSpan == null ? operation : x -> {
            auditSpan.activate();
            return operation.apply(x);
        };
    }

    public static <T> Callable<T> callableWithinAuditSpan(@Nullable AuditSpan auditSpan, Callable<T> operation) {
        return auditSpan == null ? operation : () -> {
            auditSpan.activate();
            return operation.call();
        };
    }
}

