/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.io.WritableComparable;
import net.snowflake.ingest.internal.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class NullWritable
implements WritableComparable<NullWritable> {
    private static final NullWritable THIS = new NullWritable();

    private NullWritable() {
    }

    public static NullWritable get() {
        return THIS;
    }

    public String toString() {
        return "(null)";
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(NullWritable other) {
        return 0;
    }

    public boolean equals(Object other) {
        return other instanceof NullWritable;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    static {
        WritableComparator.define(NullWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(NullWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            assert (0 == l1);
            assert (0 == l2);
            return 0;
        }
    }
}

