/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.Writable;
import net.snowflake.ingest.internal.apache.hadoop.io.WritableFactory;
import net.snowflake.ingest.internal.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class WritableFactories {
    private static final Map<Class, WritableFactory> CLASS_TO_FACTORY = new ConcurrentHashMap<Class, WritableFactory>();

    private WritableFactories() {
    }

    public static void setFactory(Class c, WritableFactory factory) {
        CLASS_TO_FACTORY.put(c, factory);
    }

    public static WritableFactory getFactory(Class c) {
        return CLASS_TO_FACTORY.get(c);
    }

    public static Writable newInstance(Class<? extends Writable> c, Configuration conf) {
        WritableFactory factory = WritableFactories.getFactory(c);
        if (factory != null) {
            Writable result = factory.newInstance();
            if (result instanceof Configurable) {
                ((Configurable)((Object)result)).setConf(conf);
            }
            return result;
        }
        return ReflectionUtils.newInstance(c, conf);
    }

    public static Writable newInstance(Class<? extends Writable> c) {
        return WritableFactories.newInstance(c, null);
    }
}

