/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.fs.PositionedReadable;
import net.snowflake.ingest.internal.apache.hadoop.fs.Seekable;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatistics;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsSource;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsSupport;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CodecPool;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class CompressionInputStream
extends InputStream
implements Seekable,
IOStatisticsSource {
    protected final InputStream in;
    protected long maxAvailableData = 0L;
    private Decompressor trackedDecompressor;

    protected CompressionInputStream(InputStream in) throws IOException {
        if (!(in instanceof Seekable) || !(in instanceof PositionedReadable)) {
            this.maxAvailableData = in.available();
        }
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (this.trackedDecompressor != null) {
                CodecPool.returnDecompressor(this.trackedDecompressor);
                this.trackedDecompressor = null;
            }
        }
    }

    @Override
    public IOStatistics getIOStatistics() {
        return IOStatisticsSupport.retrieveIOStatistics(this.in);
    }

    @Override
    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract void resetState() throws IOException;

    @Override
    public long getPos() throws IOException {
        if (!(this.in instanceof Seekable) || !(this.in instanceof PositionedReadable)) {
            return this.maxAvailableData - (long)this.in.available();
        }
        return ((Seekable)((Object)this.in)).getPos();
    }

    @Override
    public void seek(long pos) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    void setTrackedDecompressor(Decompressor decompressor) {
        this.trackedDecompressor = decompressor;
    }
}

