/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.erasurecode;

import java.nio.ByteBuffer;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ECChunk {
    private ByteBuffer chunkBuffer;
    private boolean allZero = false;

    public ECChunk(ByteBuffer buffer) {
        this.chunkBuffer = buffer;
    }

    public ECChunk(ByteBuffer buffer, int offset, int len) {
        ByteBuffer tmp = buffer.duplicate();
        tmp.position(offset);
        tmp.limit(offset + len);
        this.chunkBuffer = tmp.slice();
    }

    public ECChunk(byte[] buffer) {
        this.chunkBuffer = ByteBuffer.wrap(buffer);
    }

    public ECChunk(byte[] buffer, int offset, int len) {
        this.chunkBuffer = ByteBuffer.wrap(buffer, offset, len);
    }

    public boolean isAllZero() {
        return this.allZero;
    }

    public void setAllZero(boolean allZero) {
        this.allZero = allZero;
    }

    public ByteBuffer getBuffer() {
        return this.chunkBuffer;
    }

    public static ByteBuffer[] toBuffers(ECChunk[] chunks) {
        ByteBuffer[] buffers = new ByteBuffer[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            ECChunk chunk = chunks[i];
            buffers[i] = chunk == null ? null : chunk.getBuffer();
        }
        return buffers;
    }

    public byte[] toBytesArray() {
        byte[] bytesArr = new byte[this.chunkBuffer.remaining()];
        this.chunkBuffer.mark();
        this.chunkBuffer.get(bytesArr);
        this.chunkBuffer.reset();
        return bytesArr;
    }
}

