/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.CodecUtil;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECBlock;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECBlockGroup;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureDecoder;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.coder.ErasureDecodingStep;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;

@InterfaceAudience.Private
public class XORErasureDecoder
extends ErasureDecoder {
    public XORErasureDecoder(ErasureCoderOptions options) {
        super(options);
    }

    @Override
    protected ErasureCodingStep prepareDecodingStep(ECBlockGroup blockGroup) {
        RawErasureDecoder rawDecoder = CodecUtil.createRawDecoder(this.getConf(), "xor", this.getOptions());
        ECBlock[] inputBlocks = this.getInputBlocks(blockGroup);
        return new ErasureDecodingStep(inputBlocks, this.getErasedIndexes(inputBlocks), this.getOutputBlocks(blockGroup), rawDecoder);
    }

    @Override
    protected ECBlock[] getOutputBlocks(ECBlockGroup blockGroup) {
        int i;
        int erasedNum = this.getNumErasedBlocks(blockGroup);
        ECBlock[] outputBlocks = new ECBlock[erasedNum];
        int idx = 0;
        for (i = 0; i < this.getNumParityUnits(); ++i) {
            if (!blockGroup.getParityBlocks()[i].isErased()) continue;
            outputBlocks[idx++] = blockGroup.getParityBlocks()[i];
        }
        for (i = 0; i < this.getNumDataUnits(); ++i) {
            if (!blockGroup.getDataBlocks()[i].isErased()) continue;
            outputBlocks[idx++] = blockGroup.getDataBlocks()[i];
        }
        return outputBlocks;
    }
}

