/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ECChunk;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.ByteArrayEncodingState;
import net.snowflake.ingest.internal.apache.hadoop.io.erasurecode.rawcoder.ByteBufferEncodingState;

@InterfaceAudience.Private
public abstract class RawErasureEncoder {
    private final ErasureCoderOptions coderOptions;

    public RawErasureEncoder(ErasureCoderOptions coderOptions) {
        this.coderOptions = coderOptions;
    }

    public void encode(ByteBuffer[] inputs, ByteBuffer[] outputs) throws IOException {
        int i;
        ByteBufferEncodingState bbeState = new ByteBufferEncodingState(this, inputs, outputs);
        boolean usingDirectBuffer = bbeState.usingDirectBuffer;
        int dataLen = bbeState.encodeLength;
        if (dataLen == 0) {
            return;
        }
        int[] inputPositions = new int[inputs.length];
        for (i = 0; i < inputPositions.length; ++i) {
            if (inputs[i] == null) continue;
            inputPositions[i] = inputs[i].position();
        }
        if (usingDirectBuffer) {
            this.doEncode(bbeState);
        } else {
            ByteArrayEncodingState baeState = bbeState.convertToByteArrayState();
            this.doEncode(baeState);
        }
        for (i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            inputs[i].position(inputPositions[i] + dataLen);
        }
    }

    protected abstract void doEncode(ByteBufferEncodingState var1) throws IOException;

    public void encode(byte[][] inputs, byte[][] outputs) throws IOException {
        ByteArrayEncodingState baeState = new ByteArrayEncodingState(this, inputs, outputs);
        int dataLen = baeState.encodeLength;
        if (dataLen == 0) {
            return;
        }
        this.doEncode(baeState);
    }

    protected abstract void doEncode(ByteArrayEncodingState var1) throws IOException;

    public void encode(ECChunk[] inputs, ECChunk[] outputs) throws IOException {
        ByteBuffer[] newInputs = ECChunk.toBuffers(inputs);
        ByteBuffer[] newOutputs = ECChunk.toBuffers(outputs);
        this.encode(newInputs, newOutputs);
    }

    public int getNumDataUnits() {
        return this.coderOptions.getNumDataUnits();
    }

    public int getNumParityUnits() {
        return this.coderOptions.getNumParityUnits();
    }

    public int getNumAllUnits() {
        return this.coderOptions.getNumAllUnits();
    }

    public boolean preferDirectBuffer() {
        return false;
    }

    public boolean allowChangeInputs() {
        return this.coderOptions.allowChangeInputs();
    }

    public boolean allowVerboseDump() {
        return this.coderOptions.allowVerboseDump();
    }

    public void release() {
    }
}

