/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.ipc.metrics;

import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RetryCache;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.annotation.Metric;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.annotation.Metrics;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.MetricsRegistry;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Metrics(about="Aggregate RetryCache metrics", context="rpc")
public class RetryCacheMetrics {
    static final Logger LOG = LoggerFactory.getLogger(RetryCacheMetrics.class);
    final MetricsRegistry registry;
    final String name;
    @Metric(value={"Number of RetryCache hit"})
    MutableCounterLong cacheHit;
    @Metric(value={"Number of RetryCache cleared"})
    MutableCounterLong cacheCleared;
    @Metric(value={"Number of RetryCache updated"})
    MutableCounterLong cacheUpdated;

    RetryCacheMetrics(RetryCache retryCache) {
        this.name = "RetryCache." + retryCache.getCacheName();
        this.registry = new MetricsRegistry(this.name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialized " + this.registry);
        }
    }

    public String getName() {
        return this.name;
    }

    public static RetryCacheMetrics create(RetryCache cache) {
        RetryCacheMetrics m4 = new RetryCacheMetrics(cache);
        return DefaultMetricsSystem.instance().register(m4.name, null, m4);
    }

    public void incrCacheHit() {
        this.cacheHit.incr();
    }

    public void incrCacheCleared() {
        this.cacheCleared.incr();
    }

    public void incrCacheUpdated() {
        this.cacheUpdated.incr();
    }

    public long getCacheHit() {
        return this.cacheHit.value();
    }

    public long getCacheCleared() {
        return this.cacheCleared.value();
    }

    public long getCacheUpdated() {
        return this.cacheUpdated.value();
    }
}

