/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.ipc.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.snowflake.ingest.internal.apache.hadoop.ipc.GenericRefreshProtocol;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtobufHelper;
import net.snowflake.ingest.internal.apache.hadoop.ipc.ProtocolMetaInterface;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RPC;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RefreshResponse;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RpcClientUtil;
import net.snowflake.ingest.internal.apache.hadoop.ipc.proto.GenericRefreshProtocolProtos;
import net.snowflake.ingest.internal.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.RpcController;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.protobuf.ServiceException;

public class GenericRefreshProtocolClientSideTranslatorPB
implements ProtocolMetaInterface,
GenericRefreshProtocol,
Closeable {
    private static final RpcController NULL_CONTROLLER = null;
    private final GenericRefreshProtocolPB rpcProxy;

    public GenericRefreshProtocolClientSideTranslatorPB(GenericRefreshProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public Collection<RefreshResponse> refresh(String identifier, String[] args) throws IOException {
        List<String> argList = Arrays.asList(args);
        try {
            GenericRefreshProtocolProtos.GenericRefreshRequestProto request = GenericRefreshProtocolProtos.GenericRefreshRequestProto.newBuilder().setIdentifier(identifier).addAllArgs(argList).build();
            GenericRefreshProtocolProtos.GenericRefreshResponseCollectionProto resp = this.rpcProxy.refresh(NULL_CONTROLLER, request);
            return this.unpack(resp);
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
    }

    private Collection<RefreshResponse> unpack(GenericRefreshProtocolProtos.GenericRefreshResponseCollectionProto collection) {
        List<GenericRefreshProtocolProtos.GenericRefreshResponseProto> responseProtos = collection.getResponsesList();
        ArrayList<RefreshResponse> responses = new ArrayList<RefreshResponse>();
        for (GenericRefreshProtocolProtos.GenericRefreshResponseProto rp : responseProtos) {
            RefreshResponse response = this.unpack(rp);
            responses.add(response);
        }
        return responses;
    }

    private RefreshResponse unpack(GenericRefreshProtocolProtos.GenericRefreshResponseProto proto) {
        String message = null;
        String sender = null;
        int returnCode = -1;
        if (proto.hasUserMessage()) {
            message = proto.getUserMessage();
        }
        if (proto.hasExitStatus()) {
            returnCode = proto.getExitStatus();
        }
        if (proto.hasSenderName()) {
            sender = proto.getSenderName();
        }
        RefreshResponse response = new RefreshResponse(returnCode, message);
        response.setSenderName(sender);
        return response;
    }

    @Override
    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported(this.rpcProxy, GenericRefreshProtocolPB.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RPC.getProtocolVersion(GenericRefreshProtocolPB.class), methodName);
    }
}

