/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.metrics2;

import java.util.StringJoiner;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricType;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsInfo;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsVisitor;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.base.Objects;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractMetric
implements MetricsInfo {
    private final MetricsInfo info;

    protected AbstractMetric(MetricsInfo info) {
        this.info = Preconditions.checkNotNull(info, "metric info");
    }

    @Override
    public String name() {
        return this.info.name();
    }

    @Override
    public String description() {
        return this.info.description();
    }

    protected MetricsInfo info() {
        return this.info;
    }

    public abstract Number value();

    public abstract MetricType type();

    public abstract void visit(MetricsVisitor var1);

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMetric) {
            AbstractMetric other = (AbstractMetric)obj;
            return Objects.equal(this.info, other.info()) && Objects.equal(this.value(), other.value());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.info, this.value());
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("info=" + this.info).add("value=" + this.value()).toString();
    }
}

