/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.net;

import java.io.IOException;
import java.net.URI;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.net.DNSDomainNameResolver;
import net.snowflake.ingest.internal.apache.hadoop.net.DomainNameResolver;
import net.snowflake.ingest.internal.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class DomainNameResolverFactory {
    private DomainNameResolverFactory() {
    }

    public static DomainNameResolver newInstance(Configuration conf, URI uri, String configKey) throws IOException {
        String host = uri.getHost();
        String confKeyWithHost = configKey + "." + host;
        return DomainNameResolverFactory.newInstance(conf, confKeyWithHost);
    }

    public static DomainNameResolver newInstance(Configuration conf, String configKey) {
        Class<DomainNameResolver> resolverClass = conf.getClass(configKey, DNSDomainNameResolver.class, DomainNameResolver.class);
        return ReflectionUtils.newInstance(resolverClass, conf);
    }
}

