/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.security.GroupMappingServiceProvider;
import net.snowflake.ingest.internal.apache.hadoop.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class JniBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JniBasedUnixGroupsMapping.class);

    static native void anchorNative();

    static native String[] getGroupsForUser(String var0);

    private static void logError(int groupId, String error) {
        LOG.error("error looking up the name of group " + groupId + ": " + error);
    }

    @Override
    public List<String> getGroups(String user) throws IOException {
        String[] groups = new String[]{};
        try {
            groups = JniBasedUnixGroupsMapping.getGroupsForUser(user);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error getting groups for " + user, (Throwable)e);
            }
            LOG.info("Error getting groups for " + user + ": " + e.getMessage());
        }
        return Arrays.asList(groups);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    static {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            throw new RuntimeException("Bailing out since native library couldn't be loaded");
        }
        JniBasedUnixGroupsMapping.anchorNative();
        LOG.debug("Using JniBasedUnixGroupsMapping for Group resolution");
    }
}

