/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security;

import java.io.IOException;
import java.util.List;
import net.snowflake.ingest.internal.apache.hadoop.security.GroupMappingServiceProvider;
import net.snowflake.ingest.internal.apache.hadoop.security.JniBasedUnixGroupsNetgroupMapping;
import net.snowflake.ingest.internal.apache.hadoop.security.ShellBasedUnixGroupsNetgroupMapping;
import net.snowflake.ingest.internal.apache.hadoop.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniBasedUnixGroupsNetgroupMappingWithFallback
implements GroupMappingServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JniBasedUnixGroupsNetgroupMappingWithFallback.class);
    private GroupMappingServiceProvider impl;

    public JniBasedUnixGroupsNetgroupMappingWithFallback() {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            this.impl = new JniBasedUnixGroupsNetgroupMapping();
        } else {
            LOG.info("Falling back to shell based");
            this.impl = new ShellBasedUnixGroupsNetgroupMapping();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Group mapping impl=" + this.impl.getClass().getName());
        }
    }

    @Override
    public List<String> getGroups(String user) throws IOException {
        return this.impl.getGroups(user);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
        this.impl.cacheGroupsRefresh();
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
        this.impl.cacheGroupsAdd(groups);
    }
}

