/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.security.token;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.ipc.RetriableException;
import net.snowflake.ingest.internal.apache.hadoop.ipc.StandbyException;
import net.snowflake.ingest.internal.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class SecretManager<T extends TokenIdentifier> {
    private static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA1";
    private static final int KEY_LENGTH = 64;
    private static final ThreadLocal<Mac> threadLocalMac = new ThreadLocal<Mac>(){

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(SecretManager.DEFAULT_HMAC_ALGORITHM);
            }
            catch (NoSuchAlgorithmException nsa) {
                throw new IllegalArgumentException("Can't find HmacSHA1 algorithm.");
            }
        }
    };
    private final KeyGenerator keyGen;

    public SecretManager() {
        try {
            this.keyGen = KeyGenerator.getInstance(DEFAULT_HMAC_ALGORITHM);
            this.keyGen.init(64);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new IllegalArgumentException("Can't find HmacSHA1 algorithm.");
        }
    }

    protected abstract byte[] createPassword(T var1);

    public abstract byte[] retrievePassword(T var1) throws InvalidToken;

    public byte[] retriableRetrievePassword(T identifier) throws InvalidToken, StandbyException, RetriableException, IOException {
        return this.retrievePassword(identifier);
    }

    public abstract T createIdentifier();

    public void checkAvailableForRead() throws StandbyException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKey generateSecret() {
        SecretKey key;
        KeyGenerator keyGenerator = this.keyGen;
        synchronized (keyGenerator) {
            key = this.keyGen.generateKey();
        }
        return key;
    }

    public static byte[] createPassword(byte[] identifier, SecretKey key) {
        Mac mac = threadLocalMac.get();
        try {
            mac.init(key);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(identifier);
    }

    protected static SecretKey createSecretKey(byte[] key) {
        return new SecretKeySpec(key, DEFAULT_HMAC_ALGORITHM);
    }

    @InterfaceStability.Evolving
    public static class InvalidToken
    extends IOException {
        public InvalidToken(String msg) {
            super(msg);
        }
    }
}

