/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.service;

import java.util.ArrayList;
import java.util.List;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceStability;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.service.AbstractService;
import net.snowflake.ingest.internal.apache.hadoop.service.Service;
import net.snowflake.ingest.internal.apache.hadoop.service.ServiceOperations;
import net.snowflake.ingest.internal.apache.hadoop.service.ServiceStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CompositeService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeService.class);
    protected static final boolean STOP_ONLY_STARTED_SERVICES = false;
    private final List<Service> serviceList = new ArrayList<Service>();

    public CompositeService(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Service> getServices() {
        List<Service> list = this.serviceList;
        synchronized (list) {
            return new ArrayList<Service>(this.serviceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addService(Service service) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding service " + service.getName());
        }
        List<Service> list = this.serviceList;
        synchronized (list) {
            this.serviceList.add(service);
        }
    }

    protected boolean addIfService(Object object) {
        if (object instanceof Service) {
            this.addService((Service)object);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeService(Service service) {
        LOG.debug("Removing service {}", (Object)service.getName());
        List<Service> list = this.serviceList;
        synchronized (list) {
            return this.serviceList.remove(service);
        }
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        List<Service> services = this.getServices();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getName() + ": initing services, size=" + services.size());
        }
        for (Service service : services) {
            service.init(conf);
        }
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        List<Service> services = this.getServices();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getName() + ": starting services, size=" + services.size());
        }
        for (Service service : services) {
            service.start();
        }
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        int numOfServicesToStop = this.serviceList.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getName() + ": stopping services, size=" + numOfServicesToStop);
        }
        this.stop(numOfServicesToStop, false);
        super.serviceStop();
    }

    private void stop(int numOfServicesStarted, boolean stopOnlyStartedServices) {
        Exception firstException = null;
        List<Service> services = this.getServices();
        for (int i = numOfServicesStarted - 1; i >= 0; --i) {
            Exception ex;
            Service.STATE state;
            Service service = services.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping service #" + i + ": " + service);
            }
            if ((state = service.getServiceState()) != Service.STATE.STARTED && (stopOnlyStartedServices || state != Service.STATE.INITED) || (ex = ServiceOperations.stopQuietly(LOG, service)) == null || firstException != null) continue;
            firstException = ex;
        }
        if (firstException != null) {
            throw ServiceStateException.convert(firstException);
        }
    }

    public static class CompositeServiceShutdownHook
    implements Runnable {
        private CompositeService compositeService;

        public CompositeServiceShutdownHook(CompositeService compositeService) {
            this.compositeService = compositeService;
        }

        @Override
        public void run() {
            ServiceOperations.stopQuietly(this.compositeService);
        }
    }
}

