/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util;

import java.util.HashMap;
import java.util.Map;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsInfo;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.MetricsSystem;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.annotation.Metric;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.Interns;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.MetricsRegistry;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.MutableCounterInt;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.MutableGaugeLong;
import net.snowflake.ingest.internal.apache.hadoop.metrics2.lib.MutableQuantiles;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class ReadWriteDiskValidatorMetrics {
    @Metric(value={"# of disk failure"})
    MutableCounterInt failureCount;
    @Metric(value={"Time of last failure"})
    MutableGaugeLong lastFailureTime;
    private final MetricsRegistry registry;
    private static final MetricsInfo RECORD_INFO = Interns.info("ReadWriteDiskValidatorMetrics", "Metrics for the DiskValidator");
    private final int[] quantileIntervals = new int[]{3600, 86400, 864000};
    private final MutableQuantiles[] fileReadQuantiles;
    private final MutableQuantiles[] fileWriteQuantiles;
    protected static final Map<String, ReadWriteDiskValidatorMetrics> DIR_METRICS = new HashMap<String, ReadWriteDiskValidatorMetrics>();

    public ReadWriteDiskValidatorMetrics() {
        int interval;
        int i;
        this.registry = new MetricsRegistry(RECORD_INFO);
        this.fileReadQuantiles = new MutableQuantiles[this.quantileIntervals.length];
        for (i = 0; i < this.fileReadQuantiles.length; ++i) {
            interval = this.quantileIntervals[i];
            this.fileReadQuantiles[i] = this.registry.newQuantiles("readLatency" + interval + "s", "File read latency", "Ops", "latencyMicros", interval);
        }
        this.fileWriteQuantiles = new MutableQuantiles[this.quantileIntervals.length];
        for (i = 0; i < this.fileWriteQuantiles.length; ++i) {
            interval = this.quantileIntervals[i];
            this.fileWriteQuantiles[i] = this.registry.newQuantiles("writeLatency" + interval + "s", "File write latency", "Ops", "latencyMicros", interval);
        }
    }

    public static synchronized ReadWriteDiskValidatorMetrics getMetric(String dirName) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ReadWriteDiskValidatorMetrics metrics = DIR_METRICS.get(dirName);
        if (metrics == null) {
            metrics = new ReadWriteDiskValidatorMetrics();
            if (ms != null) {
                metrics = ms.register(ReadWriteDiskValidatorMetrics.sourceName(dirName), "Metrics for directory: " + dirName, metrics);
            }
            DIR_METRICS.put(dirName, metrics);
        }
        return metrics;
    }

    public void addWriteFileLatency(long writeLatency) {
        if (this.fileWriteQuantiles != null) {
            for (MutableQuantiles q : this.fileWriteQuantiles) {
                q.add(writeLatency);
            }
        }
    }

    public void addReadFileLatency(long readLatency) {
        if (this.fileReadQuantiles != null) {
            for (MutableQuantiles q : this.fileReadQuantiles) {
                q.add(readLatency);
            }
        }
    }

    protected static String sourceName(String dirName) {
        StringBuilder sb = new StringBuilder(RECORD_INFO.name());
        sb.append(",dir=").append(dirName);
        return sb.toString();
    }

    public void diskCheckFailed() {
        this.failureCount.incr();
        this.lastFailureTime.set(System.nanoTime());
    }

    @VisibleForTesting
    protected MutableQuantiles[] getFileReadQuantiles() {
        return this.fileReadQuantiles;
    }

    @VisibleForTesting
    protected MutableQuantiles[] getFileWriteQuantiles() {
        return this.fileWriteQuantiles;
    }
}

