/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.hadoop.util;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.snowflake.ingest.internal.apache.hadoop.classification.InterfaceAudience;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.DurationTracker;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.DurationTrackerFactory;
import net.snowflake.ingest.internal.apache.hadoop.fs.statistics.IOStatisticsSupport;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.util.concurrent.ForwardingExecutorService;
import net.snowflake.ingest.internal.apache.hadoop.thirdparty.com.google.common.util.concurrent.Futures;

@InterfaceAudience.Private
public class SemaphoredDelegatingExecutor
extends ForwardingExecutorService {
    private final Semaphore queueingPermits;
    private final ExecutorService executorDelegatee;
    private final int permitCount;
    private final DurationTrackerFactory trackerFactory;

    public SemaphoredDelegatingExecutor(ExecutorService executorDelegatee, int permitCount, boolean fair, DurationTrackerFactory trackerFactory) {
        this.permitCount = permitCount;
        this.queueingPermits = new Semaphore(permitCount, fair);
        this.executorDelegatee = Objects.requireNonNull(executorDelegatee);
        this.trackerFactory = trackerFactory != null ? trackerFactory : IOStatisticsSupport.stubDurationTrackerFactory();
    }

    public SemaphoredDelegatingExecutor(ExecutorService executorDelegatee, int permitCount, boolean fair) {
        this(executorDelegatee, permitCount, fair, null);
    }

    @Override
    protected ExecutorService delegate() {
        return this.executorDelegatee;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try (DurationTracker ignored = this.trackerFactory.trackDuration("action_executor_acquired");){
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new CallableWithPermitRelease<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        try (DurationTracker ignored = this.trackerFactory.trackDuration("action_executor_acquired");){
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new RunnableWithPermitRelease(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        try (DurationTracker ignored = this.trackerFactory.trackDuration("action_executor_acquired");){
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new RunnableWithPermitRelease(task));
    }

    @Override
    public void execute(Runnable command) {
        try (DurationTracker ignored = this.trackerFactory.trackDuration("action_executor_acquired");){
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.execute(new RunnableWithPermitRelease(command));
    }

    public int getAvailablePermits() {
        return this.queueingPermits.availablePermits();
    }

    public int getWaitingCount() {
        return this.queueingPermits.getQueueLength();
    }

    public int getPermitCount() {
        return this.permitCount;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SemaphoredDelegatingExecutor{");
        sb.append("permitCount=").append(this.getPermitCount()).append(", available=").append(this.getAvailablePermits()).append(", waiting=").append(this.getWaitingCount()).append('}');
        return sb.toString();
    }

    class CallableWithPermitRelease<T>
    implements Callable<T> {
        private Callable<T> delegatee;

        CallableWithPermitRelease(Callable<T> delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public T call() throws Exception {
            try {
                T t2 = this.delegatee.call();
                return t2;
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }

    class RunnableWithPermitRelease
    implements Runnable {
        private Runnable delegatee;

        RunnableWithPermitRelease(Runnable delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public void run() {
            try {
                this.delegatee.run();
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }
}

