/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.column.values.deltastrings;

import java.io.IOException;
import net.snowflake.ingest.internal.apache.parquet.bytes.ByteBufferInputStream;
import net.snowflake.ingest.internal.apache.parquet.column.values.RequiresPreviousReader;
import net.snowflake.ingest.internal.apache.parquet.column.values.ValuesReader;
import net.snowflake.ingest.internal.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import net.snowflake.ingest.internal.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import net.snowflake.ingest.internal.apache.parquet.io.api.Binary;

public class DeltaByteArrayReader
extends ValuesReader
implements RequiresPreviousReader {
    private ValuesReader prefixLengthReader = new DeltaBinaryPackingValuesReader();
    private ValuesReader suffixReader = new DeltaLengthByteArrayValuesReader();
    private Binary previous = Binary.fromConstantByteArray(new byte[0]);

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream stream) throws IOException {
        this.prefixLengthReader.initFromPage(valueCount, stream);
        this.suffixReader.initFromPage(valueCount, stream);
    }

    @Override
    public void skip() {
        this.readBytes();
    }

    @Override
    public Binary readBytes() {
        int prefixLength = this.prefixLengthReader.readInteger();
        Binary suffix = this.suffixReader.readBytes();
        int length = prefixLength + suffix.length();
        if (prefixLength != 0) {
            byte[] out = new byte[length];
            System.arraycopy(this.previous.getBytesUnsafe(), 0, out, 0, prefixLength);
            System.arraycopy(suffix.getBytesUnsafe(), 0, out, prefixLength, suffix.length());
            this.previous = Binary.fromConstantByteArray(out);
        } else {
            this.previous = suffix;
        }
        return this.previous;
    }

    @Override
    public void setPreviousReader(ValuesReader reader) {
        if (reader != null) {
            this.previous = ((DeltaByteArrayReader)reader).previous;
        }
    }
}

