/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.crypto;

import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.fs.Path;
import net.snowflake.ingest.internal.apache.parquet.crypto.FileDecryptionProperties;
import net.snowflake.ingest.internal.apache.parquet.crypto.ParquetCryptoRuntimeException;
import net.snowflake.ingest.internal.apache.parquet.hadoop.BadConfigurationException;
import net.snowflake.ingest.internal.apache.parquet.hadoop.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DecryptionPropertiesFactory {
    public static final Logger LOG = LoggerFactory.getLogger(DecryptionPropertiesFactory.class);
    public static final String CRYPTO_FACTORY_CLASS_PROPERTY_NAME = "parquet.crypto.factory.class";

    public static DecryptionPropertiesFactory loadFactory(Configuration conf) {
        Class<?> decryptionPropertiesFactoryClass = ConfigurationUtil.getClassFromConfig(conf, CRYPTO_FACTORY_CLASS_PROPERTY_NAME, DecryptionPropertiesFactory.class);
        if (null == decryptionPropertiesFactoryClass) {
            LOG.debug("DecryptionPropertiesFactory is not configured - name not found in hadoop config");
            return null;
        }
        try {
            return (DecryptionPropertiesFactory)decryptionPropertiesFactoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BadConfigurationException("could not instantiate decryptionPropertiesFactoryClass class: " + decryptionPropertiesFactoryClass, e);
        }
    }

    public FileDecryptionProperties getFileDecryptionProperties(Configuration var1, Path var2) throws ParquetCryptoRuntimeException;
}

