/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configurable;
import net.snowflake.ingest.internal.apache.hadoop.conf.Configuration;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionCodec;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionOutputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Compressor;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.Decompressor;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.NonBlockedCompressorStream;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.NonBlockedDecompressorStream;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.SnappyCompressor;
import net.snowflake.ingest.internal.apache.parquet.hadoop.codec.SnappyDecompressor;

public class SnappyCodec
implements Configurable,
CompressionCodec {
    private Configuration conf;
    private final String BUFFER_SIZE_CONFIG = "io.file.buffer.size";

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public Compressor createCompressor() {
        return new SnappyCompressor();
    }

    @Override
    public Decompressor createDecompressor() {
        return new SnappyDecompressor();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream stream) throws IOException {
        return this.createInputStream(stream, this.createDecompressor());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream stream, Decompressor decompressor) throws IOException {
        return new NonBlockedDecompressorStream(stream, decompressor, this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream stream) throws IOException {
        return this.createOutputStream(stream, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream stream, Compressor compressor) throws IOException {
        return new NonBlockedCompressorStream(stream, compressor, this.conf.getInt("io.file.buffer.size", 4096));
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return SnappyCompressor.class;
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return SnappyDecompressor.class;
    }

    @Override
    public String getDefaultExtension() {
        return ".snappy";
    }
}

