/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.parquet.hadoop.codec;

import java.io.IOException;
import java.io.InputStream;
import net.snowflake.ingest.internal.apache.hadoop.io.compress.CompressionInputStream;
import net.snowflake.ingest.internal.com.github.luben.zstd.BufferPool;
import net.snowflake.ingest.internal.com.github.luben.zstd.ZstdInputStream;

public class ZstdDecompressorStream
extends CompressionInputStream {
    private ZstdInputStream zstdInputStream;

    public ZstdDecompressorStream(InputStream stream) throws IOException {
        super(stream);
        this.zstdInputStream = new ZstdInputStream(stream);
    }

    public ZstdDecompressorStream(InputStream stream, BufferPool pool) throws IOException {
        super(stream);
        this.zstdInputStream = new ZstdInputStream(stream, pool);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.zstdInputStream.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        return this.zstdInputStream.read();
    }

    @Override
    public void resetState() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.zstdInputStream.close();
        }
        finally {
            super.close();
        }
    }
}

